/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyBroadExceptionInspection;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AddCallSuperQuickFix;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMissingConstructorInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.missing.super.constructor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyMissingConstructorInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyMissingConstructorInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyMissingConstructorInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyMissingConstructorInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyMissingConstructorInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyClass(PyClass node) {
            PyExpression[] superClasses = node.getSuperClassExpressions();
            if (superClasses.length == 0 || superClasses.length == 1 && "object".equals(superClasses[0].getText())) {
                return;
            }
            if (!this.superHasConstructor(node)) {
                return;
            }
            PyFunction initMethod = node.findMethodByName("__init__", false);
            if (initMethod != null) {
                if (this.isExceptionClass(node, this.myTypeEvalContext) || this.hasConstructorCall(node, initMethod)) {
                    return;
                }
                if (superClasses.length == 1 || node.isNewStyleClass()) {
                    this.registerProblem(initMethod.getNameIdentifier(), PyBundle.message("INSP.missing.super.constructor.message", new Object[0]), new AddCallSuperQuickFix());
                } else {
                    this.registerProblem(initMethod.getNameIdentifier(), PyBundle.message("INSP.missing.super.constructor.message", new Object[0]));
                }
            }
        }

        private boolean superHasConstructor(@NotNull PyClass cls) {
            if (cls == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "com/jetbrains/python/inspections/PyMissingConstructorInspection$Visitor", "superHasConstructor"));
            }
            String className = cls.getName();
            for (PyClass c : cls.getAncestorClasses(this.myTypeEvalContext)) {
                String name = c.getName();
                if (PyUtil.isObjectClass(c) || Comparing.equal((String)className, (String)name) || c.findMethodByName("__init__", false) == null) continue;
                return true;
            }
            return false;
        }

        private boolean isExceptionClass(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
            if (cls == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "com/jetbrains/python/inspections/PyMissingConstructorInspection$Visitor", "isExceptionClass"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/inspections/PyMissingConstructorInspection$Visitor", "isExceptionClass"));
            }
            if (PyBroadExceptionInspection.equalsException(cls, context)) {
                return true;
            }
            for (PyClass baseClass : cls.getAncestorClasses(this.myTypeEvalContext)) {
                if (!PyBroadExceptionInspection.equalsException(baseClass, context)) continue;
                return true;
            }
            return false;
        }

        private boolean hasConstructorCall(PyClass node, PyFunction initMethod) {
            PyStatementList statementList = initMethod.getStatementList();
            CallVisitor visitor = new CallVisitor(node);
            if (statementList != null) {
                statementList.accept(visitor);
                return visitor.myHasConstructorCall;
            }
            return false;
        }

        private class CallVisitor
        extends PyRecursiveElementVisitor {
            private boolean myHasConstructorCall = false;
            private PyClass myClass;

            CallVisitor(PyClass node) {
                this.myClass = node;
            }

            @Override
            public void visitPyCallExpression(PyCallExpression node) {
                if (this.isConstructorCall(node, this.myClass)) {
                    this.myHasConstructorCall = true;
                }
            }

            private boolean isConstructorCall(PyCallExpression expression, PyClass cl) {
                PyExpression qualifier;
                PyExpression callee = expression.getCallee();
                if (callee instanceof PyQualifiedExpression && (qualifier = ((PyQualifiedExpression)callee).getQualifier()) != null) {
                    String tmp = "";
                    if (qualifier instanceof PyCallExpression) {
                        PyExpression innerCallee = ((PyCallExpression)qualifier).getCallee();
                        if (innerCallee != null) {
                            tmp = innerCallee.getName();
                        }
                        if ("super".equals(tmp) && "__init__".equals(callee.getName())) {
                            PyExpression[] args = ((PyCallExpression)qualifier).getArguments();
                            if (args.length > 0) {
                                String firstArg = args[0].getText();
                                String qualifiedName = cl.getQualifiedName();
                                if (firstArg.equals(cl.getName()) || firstArg.equals("self.__class__") || qualifiedName != null && qualifiedName.endsWith(firstArg)) {
                                    return true;
                                }
                                for (PyClass s : cl.getAncestorClasses(Visitor.this.myTypeEvalContext)) {
                                    if (!firstArg.equals(s.getName())) continue;
                                    return true;
                                }
                            } else {
                                return true;
                            }
                        }
                    }
                    if ("__init__".equals(callee.getName())) {
                        return this.isSuperClassCall(cl, qualifier);
                    }
                }
                return false;
            }

            private boolean isSuperClassCall(PyClass cl, PyExpression qualifier) {
                PsiElement callingClass = null;
                if (qualifier instanceof PyCallExpression) {
                    PsiReference ref;
                    PyExpression innerCallee = ((PyCallExpression)qualifier).getCallee();
                    if (innerCallee != null && (ref = innerCallee.getReference()) != null) {
                        callingClass = ref.resolve();
                    }
                } else {
                    PsiReference ref = qualifier.getReference();
                    if (ref != null) {
                        callingClass = ref.resolve();
                    }
                }
                for (PyClass s : cl.getAncestorClasses(Visitor.this.myTypeEvalContext)) {
                    if (!s.equals(callingClass)) continue;
                    return true;
                }
                return false;
            }
        }
    }
}

