/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AddSelfQuickFix;
import com.jetbrains.python.inspections.quickfix.RenameParameterQuickFix;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMethodParametersInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.problematic.first.parameter", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyMethodParametersInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyMethodParametersInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyMethodParametersInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyMethodParametersInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyMethodParametersInspection", "buildVisitor"));
        }
        return visitor;
    }

    public static class Visitor
    extends PyInspectionVisitor {
        private Ref<PsiElement> myPossibleZopeRef;

        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyMethodParametersInspection$Visitor", "<init>"));
            }
            super(holder, session);
            this.myPossibleZopeRef = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private PsiElement findZopeInterface(PsiElement foothold) {
            PsiElement ret;
            Visitor visitor = this;
            synchronized (visitor) {
                if (this.myPossibleZopeRef == null) {
                    this.myPossibleZopeRef = new Ref();
                    ret = ResolveImportUtil.resolveModuleInRoots(QualifiedName.fromComponents((String[])new String[]{"zope.interface.Interface"}), foothold);
                    this.myPossibleZopeRef.set((Object)ret);
                } else {
                    ret = (PsiElement)this.myPossibleZopeRef.get();
                }
            }
            return ret;
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            for (PyInspectionExtension extension : (PyInspectionExtension[])Extensions.getExtensions(PyInspectionExtension.EP_NAME)) {
                if (!extension.ignoreMethodParameters(node)) continue;
                return;
            }
            PsiElement zope_interface = this.findZopeInterface(node);
            PyClass cls = node.getContainingClass();
            if (zope_interface instanceof PyClass && cls != null && cls.isSubclass((PyClass)zope_interface)) {
                return;
            }
            PyUtil.MethodFlags flags = PyUtil.MethodFlags.of(node);
            if (flags != null) {
                PyParameterList plist = node.getParameterList();
                PyParameter[] params = plist.getParameters();
                String methodName = node.getName();
                String CLS = "cls";
                String MCS = "mcs";
                if (params.length == 0) {
                    if (flags.isStaticMethod()) {
                        return;
                    }
                    ASTNode name_node = node.getNameNode();
                    if (name_node != null) {
                        PsiElement open_paren = plist.getFirstChild();
                        PsiElement close_paren = plist.getLastChild();
                        if (open_paren != null && close_paren != null && "(".equals(open_paren.getText()) && ")".equals(close_paren.getText())) {
                            String paramName = flags.isMetaclassMethod() ? (flags.isClassMethod() ? "mcs" : "cls") : (flags.isClassMethod() ? "cls" : "self");
                            this.registerProblem((PsiElement)plist, PyBundle.message("INSP.must.have.first.parameter", paramName), ProblemHighlightType.GENERIC_ERROR, null, new AddSelfQuickFix(paramName));
                        }
                    }
                } else {
                    PyNamedParameter first_param = params[0].getAsNamed();
                    if (first_param != null) {
                        String pname = first_param.getName();
                        if (pname == null) {
                            return;
                        }
                        String[] mangled = new String[]{"eslf", "sself", "elf", "felf", "slef", "seelf", "slf", "sslf", "sefl", "sellf", "sef", "seef"};
                        if (PyUtil.among(pname, mangled)) {
                            this.registerProblem(PyUtil.sure(params[0].getNode()).getPsi(), PyBundle.message("INSP.probably.mistyped.self", new Object[0]), new RenameParameterQuickFix("self"));
                            return;
                        }
                        if (flags.isMetaclassMethod()) {
                            String expectedName;
                            if (flags.isStaticMethod() && !"__new__".equals(methodName)) {
                                return;
                            }
                            String alternativeName = null;
                            if ("__new__".equals(methodName) || flags.isClassMethod()) {
                                expectedName = "mcs";
                            } else if (flags.isSpecialMetaclassMethod()) {
                                expectedName = "cls";
                            } else {
                                expectedName = "self";
                                alternativeName = "cls";
                            }
                            if (!(expectedName.equals(pname) || alternativeName != null && alternativeName.equals(pname))) {
                                this.registerProblem(PyUtil.sure(params[0].getNode()).getPsi(), PyBundle.message("INSP.usually.named.$0", expectedName), new RenameParameterQuickFix(expectedName));
                            }
                        } else if (flags.isClassMethod() || "__new__".equals(methodName)) {
                            if (!"cls".equals(pname)) {
                                this.registerProblem(PyUtil.sure(params[0].getNode()).getPsi(), PyBundle.message("INSP.usually.named.$0", "cls"), new RenameParameterQuickFix("cls"));
                            }
                        } else if (!(flags.isStaticMethod() || first_param.isPositionalContainer() || "self".equals(pname))) {
                            if (flags.isMetaclassMethod() && "cls".equals(pname)) {
                                return;
                            }
                            this.registerProblem(PyUtil.sure(params[0].getNode()).getPsi(), PyBundle.message("INSP.usually.named.self", new Object[0]), new RenameParameterQuickFix("self"));
                        }
                    } else if (!flags.isStaticMethod()) {
                        this.registerProblem((PsiElement)plist, PyBundle.message("INSP.first.param.must.not.be.tuple", new Object[0]));
                    }
                }
            }
        }
    }
}

