/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyMakeFunctionFromMethodQuickFix;
import com.jetbrains.python.inspections.quickfix.PyMakeMethodStaticQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.testing.PythonUnitTestUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMethodMayBeStaticInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.method.may.be.static", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyMethodMayBeStaticInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyMethodMayBeStaticInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyMethodMayBeStaticInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyMethodMayBeStaticInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyMethodMayBeStaticInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            String name;
            if (PyNames.getBuiltinMethods(LanguageLevel.forElement(node)).containsKey((Object)node.getName())) {
                return;
            }
            PyClass containingClass = node.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (PythonUnitTestUtil.isUnitTestCaseClass(containingClass)) {
                return;
            }
            PsiElement firstSuper = (PsiElement)PySuperMethodsSearch.search(node).findFirst();
            if (firstSuper != null) {
                return;
            }
            PyFunction firstOverride = (PyFunction)PyOverridingMethodsSearch.search(node, true).findFirst();
            if (firstOverride != null) {
                return;
            }
            PyDecoratorList decoratorList = node.getDecoratorList();
            if (decoratorList != null) {
                return;
            }
            if (node.getModifier() != null) {
                return;
            }
            Property property = containingClass.findPropertyByCallable(node);
            if (property != null) {
                return;
            }
            PyStatementList statementList = node.getStatementList();
            PyStatement[] statements = statementList.getStatements();
            if (statements.length == 1 && statements[0] instanceof PyPassStatement) {
                return;
            }
            PyParameter[] parameters = node.getParameterList().getParameters();
            final String selfName = parameters.length > 0 ? ((name = parameters[0].getName()) != null ? name : parameters[0].getText()) : "self";
            final boolean[] mayBeStatic = new boolean[]{true};
            PyRecursiveElementVisitor visitor = new PyRecursiveElementVisitor(){

                @Override
                public void visitPyRaiseStatement(PyRaiseStatement node) {
                    super.visitPyRaiseStatement(node);
                    PyExpression[] expressions = node.getExpressions();
                    if (expressions.length == 1) {
                        PyExpression expression = expressions[0];
                        if (expression instanceof PyCallExpression) {
                            PyExpression callee = ((PyCallExpression)expression).getCallee();
                            if (callee != null && "NotImplementedError".equals(callee.getText())) {
                                mayBeStatic[0] = false;
                            }
                        } else if ("NotImplementedError".equals(expression.getText())) {
                            mayBeStatic[0] = false;
                        }
                    }
                }

                @Override
                public void visitPyReferenceExpression(PyReferenceExpression node) {
                    super.visitPyReferenceExpression(node);
                    if (selfName.equals(node.getName())) {
                        mayBeStatic[0] = false;
                    }
                }
            };
            node.accept(visitor);
            PsiElement identifier = node.getNameIdentifier();
            if (mayBeStatic[0] && identifier != null) {
                this.registerProblem(identifier, PyBundle.message("INSP.method.may.be.static", new Object[0]), ProblemHighlightType.WEAK_WARNING, null, new PyMakeMethodStaticQuickFix(), new PyMakeFunctionFromMethodQuickFix());
            }
        }
    }
}

