/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.NameDefiner;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMethodFirstArgAssignmentInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.first.arg.assign", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyMethodFirstArgAssignmentInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyMethodFirstArgAssignmentInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyMethodFirstArgAssignmentInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyMethodFirstArgAssignmentInspection", "buildVisitor"));
        }
        return visitor;
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyMethodFirstArgAssignmentInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        private void complain(PsiElement element, String name) {
            this.registerProblem(element, PyBundle.message("INSP.first.arg.$0.assigned", name));
        }

        private void handleTarget(PyQualifiedExpression target, String name) {
            if (!target.isQualified() && name.equals(target.getText())) {
                this.complain((PsiElement)target, name);
            }
        }

        @Nullable
        private static String extractFirstParamName(PyElement node) {
            List<PsiElement> place = PyUtil.searchForWrappingMethod((PsiElement)node, true);
            if (place == null || place.size() < 2) {
                return null;
            }
            PyFunction method = (PyFunction)place.get(place.size() - 2);
            PyParameter[] params = method.getParameterList().getParameters();
            if (params.length < 1) {
                return null;
            }
            PyNamedParameter first_parm = params[0].getAsNamed();
            if (first_parm == null) {
                return null;
            }
            if (first_parm.isKeywordContainer() || first_parm.isPositionalContainer()) {
                return null;
            }
            String first_param_name = first_parm.getName();
            if (first_param_name == null || first_param_name.length() < 1) {
                return null;
            }
            PyFunction.Modifier modifier = method.getModifier();
            if (modifier == PyFunction.Modifier.STATICMETHOD) {
                return null;
            }
            return first_param_name;
        }

        private void markNameDefiner(NameDefiner definer) {
            String first_param_name = Visitor.extractFirstParamName((PyElement)((Object)definer));
            if (first_param_name != null) {
                for (PyElement elt : definer.iterateNames()) {
                    if (!(elt instanceof PyTargetExpression)) continue;
                    this.handleTarget((PyTargetExpression)elt, first_param_name);
                }
            }
        }

        @Override
        public void visitPyAssignmentStatement(PyAssignmentStatement node) {
            this.markNameDefiner(node);
        }

        @Override
        public void visitPyAugAssignmentStatement(PyAugAssignmentStatement node) {
            String first_param_name = Visitor.extractFirstParamName(node);
            if (first_param_name != null) {
                PyExpression target = node.getTarget();
                if (target instanceof PyQualifiedExpression) {
                    this.handleTarget((PyQualifiedExpression)target, first_param_name);
                } else if (target instanceof PyTupleExpression) {
                    for (PyExpression elt : PyUtil.flattenedParensAndTuples(((PyTupleExpression)target).getElements())) {
                        if (!(elt instanceof PyQualifiedExpression)) continue;
                        this.handleTarget((PyQualifiedExpression)elt, first_param_name);
                    }
                }
            }
        }

        @Override
        public void visitPyForStatement(PyForStatement node) {
            this.markNameDefiner(node);
        }

        private void markDefinition(PyElement definer) {
            String first_param_name = Visitor.extractFirstParamName(definer);
            if (first_param_name != null && first_param_name.equals(definer.getName())) {
                this.complain(definer.getNode().findChildByType((IElementType)PyTokenTypes.IDENTIFIER).getPsi(), first_param_name);
            }
        }

        @Override
        public void visitPyFunction(PyFunction definer) {
            this.markDefinition(definer);
        }

        @Override
        public void visitPyClass(PyClass definer) {
            this.markDefinition(definer);
        }
    }
}

