/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.inspections.PyEncodingUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AddEncodingQuickFix;
import com.jetbrains.python.psi.PyFile;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyMandatoryEncodingInspection
extends PyInspection {
    public String myDefaultEncoding = "utf-8";
    public int myEncodingFormatIndex = 0;

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.mandatory.encoding", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyMandatoryEncodingInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyMandatoryEncodingInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyMandatoryEncodingInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyMandatoryEncodingInspection", "buildVisitor"));
        }
        return visitor;
    }

    public JComponent createOptionsPanel() {
        JComboBox<String> defaultEncoding = new JComboBox<String>(PyEncodingUtil.POSSIBLE_ENCODINGS);
        defaultEncoding.setSelectedItem(this.myDefaultEncoding);
        defaultEncoding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                PyMandatoryEncodingInspection.this.myDefaultEncoding = (String)cb.getSelectedItem();
            }
        });
        JComboBox<String> encodingFormat = new JComboBox<String>(PyEncodingUtil.ENCODING_FORMAT);
        encodingFormat.setSelectedIndex(this.myEncodingFormatIndex);
        encodingFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                PyMandatoryEncodingInspection.this.myEncodingFormatIndex = cb.getSelectedIndex();
            }
        });
        return PyEncodingUtil.createEncodingOptionsPanel(defaultEncoding, encodingFormat);
    }

    private class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyMandatoryEncodingInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyFile(PyFile node) {
            String charsetString = PythonFileType.getCharsetFromEncodingDeclaration(node);
            if (charsetString == null) {
                TextRange tr = new TextRange(0, 0);
                ProblemsHolder holder = this.getHolder();
                if (holder != null) {
                    holder.registerProblem((PsiElement)node, tr, "No encoding specified for file", new LocalQuickFix[]{new AddEncodingQuickFix(PyMandatoryEncodingInspection.this.myDefaultEncoding, PyMandatoryEncodingInspection.this.myEncodingFormatIndex)});
                }
            }
        }
    }
}

