/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.ListCreationQuickFix;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyStatement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyListCreationInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.list.creation", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyListCreationInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyListCreationInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyListCreationInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyListCreationInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyListCreationInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyAssignmentStatement(PyAssignmentStatement node) {
            PyExpression statement;
            if (!(node.getAssignedValue() instanceof PyListLiteralExpression)) {
                return;
            }
            PyExpression[] targets = node.getTargets();
            if (targets.length != 1) {
                return;
            }
            PyExpression target = targets[0];
            String name = target.getName();
            if (name == null) {
                return;
            }
            PyStatement expressionStatement = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)node, PyStatement.class);
            if (!(expressionStatement instanceof PyExpressionStatement)) {
                return;
            }
            ListCreationQuickFix quickFix = null;
            String message = "This list creation could be rewritten as a list literal";
            while (expressionStatement instanceof PyExpressionStatement && (statement = ((PyExpressionStatement)expressionStatement).getExpression()) instanceof PyCallExpression) {
                PyCallExpression callExpression = (PyCallExpression)statement;
                PyExpression callee = callExpression.getCallee();
                if (callee instanceof PyQualifiedExpression) {
                    PyArgumentList argList;
                    PyExpression qualifier = ((PyQualifiedExpression)callee).getQualifier();
                    String funcName = ((PyQualifiedExpression)callee).getReferencedName();
                    if (qualifier != null && name.equals(qualifier.getText()) && "append".equals(funcName) && (argList = callExpression.getArgumentList()) != null) {
                        for (PyExpression argument : argList.getArguments()) {
                            if (!argument.getText().equals(name)) continue;
                            if (quickFix != null) {
                                this.registerProblem((PsiElement)node, "This list creation could be rewritten as a list literal", quickFix);
                            }
                            return;
                        }
                        if (quickFix == null) {
                            quickFix = new ListCreationQuickFix(node);
                        }
                        quickFix.addStatement((PyExpressionStatement)expressionStatement);
                    }
                }
                if (quickFix == null) {
                    return;
                }
                expressionStatement = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)expressionStatement, PyStatement.class);
            }
            if (quickFix != null) {
                this.registerProblem((PsiElement)node, "This list creation could be rewritten as a list literal", quickFix);
            }
        }
    }
}

