/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.sdk.PythonSdkType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyInterpreterInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.invalid.interpreter", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyInterpreterInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyInterpreterInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyInterpreterInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyInterpreterInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class ConfigureInterpreterFix
    implements LocalQuickFix {
        private ConfigureInterpreterFix() {
        }

        @NotNull
        public String getName() {
            if ("Configure Python Interpreter" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyInterpreterInspection$ConfigureInterpreterFix", "getName"));
            }
            return "Configure Python Interpreter";
        }

        @NotNull
        public String getFamilyName() {
            if ("Configure Python Interpreter" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyInterpreterInspection$ConfigureInterpreterFix", "getFamilyName"));
            }
            return "Configure Python Interpreter";
        }

        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/PyInterpreterInspection$ConfigureInterpreterFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/PyInterpreterInspection$ConfigureInterpreterFix", "applyFix"));
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ShowSettingsUtil.getInstance().showSettingsDialog(project, "Project Interpreter");
                }
            });
        }
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyInterpreterInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyFile(PyFile node) {
            Module module;
            super.visitPyFile(node);
            if (PlatformUtils.isPyCharm() && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)node)) != null) {
                Sdk sdk = PythonSdkType.findPythonSdk(module);
                if (sdk == null) {
                    this.registerProblem((PsiElement)node, "No Python interpreter configured for the project", new ConfigureInterpreterFix());
                } else if (PythonSdkType.isInvalid(sdk)) {
                    this.registerProblem((PsiElement)node, "Invalid Python interpreter selected for the project", new ConfigureInterpreterFix());
                }
            }
        }
    }
}

