/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyInspectionVisitor
extends PyElementVisitor {
    @Nullable
    private final ProblemsHolder myHolder;
    @NotNull
    private final LocalInspectionToolSession mySession;
    protected final TypeEvalContext myTypeEvalContext;
    public static final Key<TypeEvalContext> INSPECTION_TYPE_EVAL_CONTEXT = Key.create((String)"PyInspectionTypeEvalContext");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PyInspectionVisitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        TypeEvalContext context;
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyInspectionVisitor", "<init>"));
        }
        this.myHolder = holder;
        this.mySession = session;
        Key<TypeEvalContext> key = INSPECTION_TYPE_EVAL_CONTEXT;
        synchronized (key) {
            context = (TypeEvalContext)session.getUserData(INSPECTION_TYPE_EVAL_CONTEXT);
            if (context == null) {
                PsiFile file = session.getFile();
                context = TypeEvalContext.codeAnalysis(file.getProject(), file);
                session.putUserData(INSPECTION_TYPE_EVAL_CONTEXT, (Object)context);
            }
        }
        this.myTypeEvalContext = context;
    }

    protected PyResolveContext getResolveContext() {
        return PyResolveContext.noImplicits().withTypeEvalContext(this.myTypeEvalContext);
    }

    @Nullable
    protected ProblemsHolder getHolder() {
        return this.myHolder;
    }

    @NotNull
    public LocalInspectionToolSession getSession() {
        LocalInspectionToolSession localInspectionToolSession = this.mySession;
        if (localInspectionToolSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyInspectionVisitor", "getSession"));
        }
        return localInspectionToolSession;
    }

    protected final void registerProblem(PsiElement element, String message) {
        if (element == null || element.getTextLength() == 0) {
            return;
        }
        if (this.myHolder != null) {
            this.myHolder.registerProblem(element, message, new LocalQuickFix[0]);
        }
    }

    protected final void registerProblem(@Nullable PsiElement element, @NotNull String message, LocalQuickFix ... quickFixes) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/python/inspections/PyInspectionVisitor", "registerProblem"));
        }
        if (quickFixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFixes", "com/jetbrains/python/inspections/PyInspectionVisitor", "registerProblem"));
        }
        if (element == null || element.getTextLength() == 0) {
            return;
        }
        if (this.myHolder != null) {
            this.myHolder.registerProblem(element, message, quickFixes);
        }
    }

    protected final void registerProblem(PsiElement element, String message, ProblemHighlightType type) {
        if (element == null || element.getTextLength() == 0) {
            return;
        }
        if (this.myHolder != null) {
            this.myHolder.registerProblem(this.myHolder.getManager().createProblemDescriptor(element, message, (LocalQuickFix)null, type, this.myHolder.isOnTheFly()));
        }
    }

    protected final void registerProblem(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, ProblemHighlightType highlightType, @Nullable HintAction hintAction, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/python/inspections/PyInspectionVisitor", "registerProblem"));
        }
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptionTemplate", "com/jetbrains/python/inspections/PyInspectionVisitor", "registerProblem"));
        }
        this.registerProblem(psiElement, descriptionTemplate, highlightType, hintAction, (TextRange)null, fixes);
    }

    protected final void registerProblem(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, ProblemHighlightType highlightType, @Nullable HintAction hintAction, @Nullable TextRange rangeInElement, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/python/inspections/PyInspectionVisitor", "registerProblem"));
        }
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptionTemplate", "com/jetbrains/python/inspections/PyInspectionVisitor", "registerProblem"));
        }
        if (this.myHolder != null && !(psiElement instanceof PsiErrorElement)) {
            this.myHolder.registerProblem((ProblemDescriptor)new ProblemDescriptorImpl(psiElement, psiElement, descriptionTemplate, fixes, highlightType, false, rangeInElement, hintAction, this.myHolder.isOnTheFly()));
        }
    }
}

