/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.inspections.quickfix.PySuppressInspectionFix;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpressionCodeFragment;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.impl.PyFileImpl;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyInspection
extends LocalInspectionTool {
    private static final Pattern SUPPRESS_PATTERN = Pattern.compile("\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*");

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = PyBundle.message("INSP.GROUP.python", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyInspection", "getShortName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        ArrayList<PySuppressInspectionFix> result = new ArrayList<PySuppressInspectionFix>();
        result.add(new PySuppressInspectionFix(this.getSuppressId(), "Suppress for statement", PyStatement.class){

            @Override
            public PsiElement getContainer(PsiElement context) {
                if (PsiTreeUtil.getParentOfType((PsiElement)context, PyStatementList.class, (boolean)false, (Class[])new Class[]{ScopeOwner.class}) != null || PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{PyFunction.class, PyClass.class}) == null) {
                    return super.getContainer(context);
                }
                return null;
            }
        });
        result.add(new PySuppressInspectionFix(this.getSuppressId(), "Suppress for function", PyFunction.class));
        result.add(new PySuppressInspectionFix(this.getSuppressId(), "Suppress for class", PyClass.class));
        SuppressQuickFix[] suppressQuickFixArray = result.toArray(new SuppressQuickFix[result.size()]);
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyInspection", "getBatchSuppressActions"));
        }
        return suppressQuickFixArray;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/inspections/PyInspection", "isSuppressedFor"));
        }
        PsiFile file = element.getContainingFile();
        boolean isAccepted = true;
        if (file instanceof PyFileImpl) {
            isAccepted = ((PyFileImpl)file).isAcceptedFor(((Object)((Object)this)).getClass());
        }
        return !isAccepted || this.isSuppressedForParent(element, PyStatement.class) || this.isSuppressedForParent(element, PyFunction.class) || this.isSuppressedForParent(element, PyClass.class) || this.isSuppressForCodeFragment(element);
    }

    private boolean isSuppressForCodeFragment(PsiElement element) {
        return this.isSuppressForCodeFragment() && PsiTreeUtil.getParentOfType((PsiElement)element, PyExpressionCodeFragment.class) != null;
    }

    protected boolean isSuppressForCodeFragment() {
        return false;
    }

    private boolean isSuppressedForParent(PsiElement element, Class<? extends PyElement> parentClass) {
        PyElement parent = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)element, parentClass, (boolean)false);
        if (parent == null) {
            return false;
        }
        return this.isSuppressedForElement(parent);
    }

    private boolean isSuppressedForElement(PyElement stmt) {
        PsiElement parent;
        PsiElement prevSibling = stmt.getPrevSibling();
        if (prevSibling == null && (parent = stmt.getParent()) != null) {
            prevSibling = parent.getPrevSibling();
        }
        while (prevSibling instanceof PsiComment || prevSibling instanceof PsiWhiteSpace) {
            if (prevSibling instanceof PsiComment && this.isSuppressedInComment(prevSibling.getText().substring(1).trim())) {
                return true;
            }
            prevSibling = prevSibling.getPrevSibling();
        }
        return false;
    }

    private boolean isSuppressedInComment(String commentText) {
        Matcher m = SUPPRESS_PATTERN.matcher(commentText);
        return m.matches() && SuppressionUtil.isInspectionToolIdMentioned(m.group(1), this.getSuppressId());
    }

    protected String getSuppressId() {
        return this.getShortName().replace("Inspection", "");
    }
}

