/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyChangeSignatureQuickFix;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyInitNewSignatureInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.new.init.signature", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyInitNewSignatureInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyInitNewSignatureInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyInitNewSignatureInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyInitNewSignatureInspection", "buildVisitor"));
        }
        return visitor;
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyInitNewSignatureInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            String functionName = node.getName();
            if (!"__new__".equals(functionName) && !"__init__".equals(functionName)) {
                return;
            }
            PyClass cls = node.getContainingClass();
            if (cls == null) {
                return;
            }
            if (!cls.isNewStyleClass()) {
                return;
            }
            String complementaryName = "__new__".equals(functionName) ? "__init__" : "__new__";
            PyFunction complementaryMethod = cls.findMethodByName(complementaryName, true);
            if (complementaryMethod == null || PyUtil.isObjectClass((PyClass)ObjectUtils.assertNotNull((Object)complementaryMethod.getContainingClass()))) {
                return;
            }
            if (!PyUtil.isSignatureCompatibleTo(complementaryMethod, node, this.myTypeEvalContext) && !PyUtil.isSignatureCompatibleTo(node, complementaryMethod, this.myTypeEvalContext) && node.getContainingFile() == cls.getContainingFile()) {
                this.registerProblem((PsiElement)node.getParameterList(), "__new__".equals(node.getName()) ? PyBundle.message("INSP.new.incompatible.to.init", new Object[0]) : PyBundle.message("INSP.init.incompatible.to.new", new Object[0]), new PyChangeSignatureQuickFix(false));
            }
        }
    }
}

