/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyAddExceptionSuperClassQuickFix;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.types.PyClassLikeType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyExceptionInheritInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.exception.not.inherit", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyExceptionInheritInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyExceptionInheritInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyExceptionInheritInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyExceptionInheritInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyExceptionInheritInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyRaiseStatement(PyRaiseStatement node) {
            PyExpression callee;
            PyExpression[] expressions = node.getExpressions();
            if (expressions.length == 0) {
                return;
            }
            PyExpression expression = expressions[0];
            if (expression instanceof PyCallExpression && (callee = ((PyCallExpression)expression).getCallee()) instanceof PyReferenceExpression) {
                PsiPolyVariantReference reference = ((PyReferenceExpression)callee).getReference(this.getResolveContext());
                if (reference == null) {
                    return;
                }
                PsiElement psiElement = reference.resolve();
                if (psiElement instanceof PyClass) {
                    PyClass aClass = (PyClass)psiElement;
                    for (PyClassLikeType type : aClass.getAncestorTypes(this.myTypeEvalContext)) {
                        if (type == null) {
                            return;
                        }
                        String name = type.getName();
                        if (name != null && !"BaseException".equals(name) && !"Exception".equals(name)) continue;
                        return;
                    }
                    this.registerProblem((PsiElement)expression, "Exception doesn't inherit from base 'Exception' class", new PyAddExceptionSuperClassQuickFix());
                }
            }
        }
    }
}

