/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.HashSet;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyMoveExceptQuickFix;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyExceptClausesOrderInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.bad.except.clauses.order", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyExceptClausesOrderInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyExceptClausesOrderInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyExceptClausesOrderInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyExceptClausesOrderInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(ProblemsHolder holder, LocalInspectionToolSession session) {
            super(holder, session);
        }

        @Override
        public void visitPyTryExceptStatement(PyTryExceptStatement node) {
            PyExceptPart[] exceptParts = node.getExceptParts();
            if (exceptParts.length > 1) {
                HashSet exceptClasses = new HashSet();
                for (PyExceptPart exceptPart : exceptParts) {
                    PsiElement element;
                    PyExpression exceptClass = exceptPart.getExceptClass();
                    if (!(exceptClass instanceof PyReferenceExpression) || !((element = ((PyReferenceExpression)exceptClass).followAssignmentsChain(this.getResolveContext()).getElement()) instanceof PyClass)) continue;
                    PyClass pyClass = (PyClass)element;
                    if (exceptClasses.contains(pyClass)) {
                        this.registerProblem((PsiElement)exceptClass, PyBundle.message("INSP.class.$0.already.caught", pyClass.getName()));
                    } else {
                        for (PyClass superClass : pyClass.getSuperClasses()) {
                            if (!exceptClasses.contains(superClass)) continue;
                            this.registerProblem((PsiElement)exceptClass, PyBundle.message("INSP.class.$0.superclass.$1.already.caught", superClass.getName(), pyClass.getName()), new PyMoveExceptQuickFix());
                        }
                    }
                    exceptClasses.add(pyClass);
                }
            }
        }
    }
}

