/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import com.jetbrains.python.debugger.PySignatureUtil;
import com.jetbrains.python.documentation.DocStringUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.toolbox.Substring;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDocstringTypesInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.docstring.types", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyDocstringTypesInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyDocstringTypesInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyDocstringTypesInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyDocstringTypesInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class ChangeTypeQuickFix
    implements LocalQuickFix {
        private final String myParamName;
        private final Substring myTypeSubstring;
        private final String myNewType;
        private final PyStringLiteralExpression myStringLiteralExpression;

        private ChangeTypeQuickFix(String name, Substring substring, String type, PyStringLiteralExpression expression) {
            this.myParamName = name;
            this.myTypeSubstring = substring;
            this.myNewType = type;
            this.myStringLiteralExpression = expression;
        }

        @NotNull
        public String getName() {
            String string = "Change " + this.myParamName + " type from " + this.myTypeSubstring.getValue() + " to " + this.myNewType;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyDocstringTypesInspection$ChangeTypeQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Fix docstring" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyDocstringTypesInspection$ChangeTypeQuickFix", "getFamilyName"));
            }
            return "Fix docstring";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/PyDocstringTypesInspection$ChangeTypeQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/PyDocstringTypesInspection$ChangeTypeQuickFix", "applyFix"));
            }
            String newValue = this.myTypeSubstring.getTextRange().replace(this.myTypeSubstring.getSuperString(), this.myNewType);
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
            this.myStringLiteralExpression.replace((PsiElement)elementGenerator.createDocstring(newValue).getExpression());
        }
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyDocstringTypesInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyFunction(PyFunction function) {
            String name = function.getName();
            if (name != null && !name.startsWith("_")) {
                this.checkDocString(function);
            }
        }

        private void checkDocString(@NotNull PyFunction function) {
            PySignatureCacheManager manager;
            PySignature signature;
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/inspections/PyDocstringTypesInspection$Visitor", "checkDocString"));
            }
            PyStringLiteralExpression docStringExpression = function.getDocStringExpression();
            if (docStringExpression != null && (signature = (manager = PySignatureCacheManager.getInstance(function.getProject())).findSignature(function)) != null) {
                this.checkParameters(function, docStringExpression, signature);
            }
        }

        private void checkParameters(PyFunction function, PyStringLiteralExpression node, PySignature signature) {
            String text = node.getText();
            if (text == null) {
                return;
            }
            StructuredDocString docString = DocStringUtil.parse(text);
            if (docString == null) {
                return;
            }
            for (String param : docString.getParameters()) {
                String dynamicType;
                Substring type = docString.getParamTypeSubstring(param);
                if (type == null || (dynamicType = signature.getArgTypeQualifiedName(param)) == null) continue;
                String dynamicTypeShortName = PySignatureUtil.getShortestImportableName(function, dynamicType);
                if (this.match(function, dynamicType, type.getValue())) continue;
                this.registerProblem((PsiElement)node, "Dynamically inferred type '" + dynamicTypeShortName + "' doesn't match specified type '" + type + "'", ProblemHighlightType.WEAK_WARNING, null, type.getTextRange(), new ChangeTypeQuickFix(param, type, dynamicTypeShortName, node));
            }
        }

        private boolean match(PsiElement anchor, String dynamicTypeName, String specifiedTypeName) {
            PyType dynamicType = PyTypeParser.getTypeByName(anchor, dynamicTypeName);
            PyType specifiedType = PyTypeParser.getTypeByName(anchor, specifiedTypeName);
            return PyTypeChecker.match(specifiedType, dynamicType, this.myTypeEvalContext);
        }
    }
}

