/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.documentation.DocStringUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.DocstringQuickFix;
import com.jetbrains.python.inspections.quickfix.PySuppressInspectionFix;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.testing.PythonUnitTestUtil;
import com.jetbrains.python.toolbox.Substring;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDocstringInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.docstring", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyDocstringInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyDocstringInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyDocstringInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyDocstringInspection", "buildVisitor"));
        }
        return visitor;
    }

    @Override
    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        ArrayList<PySuppressInspectionFix> result = new ArrayList<PySuppressInspectionFix>();
        if (element != null) {
            if (PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class) != null) {
                result.add(new PySuppressInspectionFix(this.getShortName().replace("Inspection", ""), "Suppress for function", PyFunction.class));
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class) != null) {
                result.add(new PySuppressInspectionFix(this.getShortName().replace("Inspection", ""), "Suppress for class", PyClass.class));
            }
        }
        SuppressQuickFix[] suppressQuickFixArray = result.toArray(new SuppressQuickFix[result.size()]);
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyDocstringInspection", "getBatchSuppressActions"));
        }
        return suppressQuickFixArray;
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyDocstringInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyFile(PyFile node) {
            this.checkDocString(node);
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            if (PythonUnitTestUtil.isUnitTestCaseFunction(node)) {
                return;
            }
            PyClass containingClass = node.getContainingClass();
            if (containingClass != null && PythonUnitTestUtil.isUnitTestCaseClass(containingClass)) {
                return;
            }
            String name = node.getName();
            if (name != null && !name.startsWith("_")) {
                this.checkDocString(node);
            }
        }

        @Override
        public void visitPyClass(PyClass node) {
            if (PythonUnitTestUtil.isUnitTestCaseClass(node)) {
                return;
            }
            String name = node.getName();
            if (name == null || name.startsWith("_")) {
                return;
            }
            for (PyInspectionExtension extension : (PyInspectionExtension[])Extensions.getExtensions(PyInspectionExtension.EP_NAME)) {
                if (!extension.ignoreMissingDocstring(node)) continue;
                return;
            }
            this.checkDocString(node);
        }

        private void checkDocString(PyDocStringOwner node) {
            PyStringLiteralExpression docStringExpression = node.getDocStringExpression();
            if (docStringExpression == null) {
                Object marker = null;
                if (node instanceof PyClass) {
                    ASTNode n = ((PyClass)node).getNameNode();
                    if (n != null) {
                        marker = n.getPsi();
                    }
                } else if (node instanceof PyFunction) {
                    ASTNode n = ((PyFunction)node).getNameNode();
                    if (n != null) {
                        marker = n.getPsi();
                    }
                } else if (node instanceof PyFile) {
                    TextRange tr = new TextRange(0, 0);
                    ProblemsHolder holder = this.getHolder();
                    if (holder != null) {
                        holder.registerProblem((PsiElement)node, tr, PyBundle.message("INSP.no.docstring", new Object[0]), new LocalQuickFix[0]);
                    }
                    return;
                }
                if (marker == null) {
                    marker = node;
                }
                if (node instanceof PyFunction || node instanceof PyClass && ((PyClass)node).findInitOrNew(false) != null) {
                    this.registerProblem((PsiElement)marker, PyBundle.message("INSP.no.docstring", new Object[0]), new LocalQuickFix[]{new DocstringQuickFix(null, null)});
                } else {
                    this.registerProblem((PsiElement)marker, PyBundle.message("INSP.no.docstring", new Object[0]));
                }
            } else {
                boolean registered = this.checkParameters(node, docStringExpression);
                if (!registered && StringUtil.isEmptyOrSpaces((String)docStringExpression.getStringValue())) {
                    this.registerProblem(docStringExpression, PyBundle.message("INSP.empty.docstring", new Object[0]));
                }
            }
        }

        private boolean checkParameters(PyDocStringOwner pyDocStringOwner, PyStringLiteralExpression node) {
            String text = node.getText();
            if (text == null) {
                return false;
            }
            StructuredDocString docString = DocStringUtil.parse(text);
            if (docString == null) {
                return false;
            }
            List<Substring> docstringParams = docString.getParameterSubstrings();
            if (docstringParams == null) {
                return false;
            }
            if (pyDocStringOwner instanceof PyFunction) {
                List<Substring> unexpectedParams;
                PyDecoratorList decoratorList = ((PyFunction)pyDocStringOwner).getDecoratorList();
                boolean isClassMethod = false;
                if (decoratorList != null) {
                    isClassMethod = decoratorList.findDecorator("classmethod") != null;
                }
                PyParameter[] realParams = ((PyFunction)pyDocStringOwner).getParameterList().getParameters();
                List<PyParameter> missingParams = Visitor.getMissingParams(realParams, docstringParams, isClassMethod);
                boolean registered = false;
                if (!missingParams.isEmpty()) {
                    for (PyParameter param : missingParams) {
                        this.registerProblem((PsiElement)param, "Missing parameter " + param.getName() + " in docstring", new DocstringQuickFix(param.getName(), null));
                    }
                    registered = true;
                }
                if (!(unexpectedParams = Visitor.getUnexpectedParams(docstringParams, realParams, node)).isEmpty()) {
                    for (Substring param : unexpectedParams) {
                        ProblemsHolder holder = this.getHolder();
                        if (holder == null) continue;
                        holder.registerProblem((PsiElement)node, param.getTextRange(), "Unexpected parameter " + param + " in docstring", new LocalQuickFix[]{new DocstringQuickFix(null, param.getValue())});
                    }
                    registered = true;
                }
                return registered;
            }
            return false;
        }

        private static List<Substring> getUnexpectedParams(List<Substring> docstringParams, PyParameter[] realParams, PyStringLiteralExpression node) {
            HashMap unexpected = Maps.newHashMap();
            for (Substring s : docstringParams) {
                unexpected.put(s.getValue(), s);
            }
            for (PyParameter p : realParams) {
                if (!unexpected.containsKey(p.getName())) continue;
                unexpected.remove(p.getName());
            }
            return Lists.newArrayList(unexpected.values());
        }

        private static List<PyParameter> getMissingParams(PyParameter[] realParams, List<Substring> docstringParams, boolean isClassMethod) {
            ArrayList<PyParameter> missing = new ArrayList<PyParameter>();
            HashSet params = Sets.newHashSet((Iterable)Lists.transform(docstringParams, (Function)new Function<Substring, String>(){

                public String apply(Substring input) {
                    return input.getValue();
                }
            }));
            boolean hasMissing = false;
            for (PyParameter p : realParams) {
                String paramText = p.getText();
                if ((isClassMethod || paramText.equals("self") || paramText.equals("*")) && (!isClassMethod || paramText.equals("cls")) || params.contains(p.getName())) continue;
                hasMissing = true;
                missing.add(p);
            }
            return hasMissing ? missing : Collections.emptyList();
        }
    }
}

