/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.HashMap;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyRemoveDictKeyQuickFix;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDictDuplicateKeysInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.duplicate.keys", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyDictDuplicateKeysInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyDictDuplicateKeysInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyDictDuplicateKeysInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyDictDuplicateKeysInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyDictDuplicateKeysInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyDictLiteralExpression(PyDictLiteralExpression node) {
            if (node.getElements().length != 0) {
                HashMap map = new HashMap();
                for (PyKeyValueExpression exp : node.getElements()) {
                    PyExpression key = exp.getKey();
                    if (!(key instanceof PyNumericLiteralExpression) && !(key instanceof PyStringLiteralExpression) && !(key instanceof PyReferenceExpression)) continue;
                    if (map.keySet().contains(key.getText())) {
                        this.registerProblem((PsiElement)key, "Dictionary contains duplicate keys " + key.getText(), new PyRemoveDictKeyQuickFix());
                        this.registerProblem((PsiElement)map.get(key.getText()), "Dictionary contains duplicate keys " + key.getText(), new PyRemoveDictKeyQuickFix());
                    }
                    map.put(key.getText(), key);
                }
            }
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            if (Visitor.isDict(node)) {
                PyExpression[] arguments;
                HashMap map = new HashMap();
                PyArgumentList pyArgumentList = node.getArgumentList();
                if (pyArgumentList == null) {
                    return;
                }
                for (PyExpression argument : arguments = pyArgumentList.getArguments()) {
                    if (argument instanceof PyParenthesizedExpression) {
                        argument = ((PyParenthesizedExpression)argument).getContainedExpression();
                    }
                    if (argument instanceof PySequenceExpression) {
                        for (PyExpression el : ((PySequenceExpression)argument).getElements()) {
                            PsiElement key = Visitor.getKey(el);
                            this.checkKey((Map<String, PsiElement>)map, key);
                        }
                        continue;
                    }
                    PsiElement key = Visitor.getKey(argument);
                    this.checkKey((Map<String, PsiElement>)map, key);
                }
            }
        }

        private void checkKey(Map<String, PsiElement> map, PsiElement node) {
            if (node == null) {
                return;
            }
            String key = node.getText();
            if (node instanceof PyStringLiteralExpression) {
                key = ((PyStringLiteralExpression)node).getStringValue();
            }
            if (map.keySet().contains(key)) {
                this.registerProblem(node, "Dictionary contains duplicate keys " + key);
                this.registerProblem(map.get(key), "Dictionary contains duplicate keys " + key);
            }
            map.put(key, node);
        }

        @Nullable
        private static PsiElement getKey(PyElement argument) {
            ASTNode keyWord;
            PyExpression expr;
            if (argument instanceof PyParenthesizedExpression && (expr = ((PyParenthesizedExpression)argument).getContainedExpression()) instanceof PyTupleExpression) {
                return ((PyTupleExpression)expr).getElements()[0];
            }
            if (argument instanceof PyKeywordArgument && (keyWord = ((PyKeywordArgument)argument).getKeywordNode()) != null) {
                return keyWord.getPsi();
            }
            return null;
        }

        private static boolean isDict(PyCallExpression expression) {
            PyExpression callee = expression.getCallee();
            if (callee == null) {
                return false;
            }
            String name = callee.getText();
            return "dict".equals(name);
        }
    }
}

