/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.DictCreationQuickFix;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PySubscriptionExpression;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDictCreationInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.dict.creation", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyDictCreationInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyDictCreationInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyDictCreationInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyDictCreationInspection", "buildVisitor"));
        }
        return visitor;
    }

    @Nullable
    public static List<Pair<PyExpression, PyExpression>> getDictTargets(@NotNull PyExpression target, @NotNull String name, @NotNull PyAssignmentStatement assignmentStatement) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/python/inspections/PyDictCreationInspection", "getDictTargets"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/inspections/PyDictCreationInspection", "getDictTargets"));
        }
        if (assignmentStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignmentStatement", "com/jetbrains/python/inspections/PyDictCreationInspection", "getDictTargets"));
        }
        ArrayList<Pair<PyExpression, PyExpression>> targets = new ArrayList<Pair<PyExpression, PyExpression>>();
        for (Pair<PyExpression, PyExpression> targetToValue : assignmentStatement.getTargetsToValuesMapping()) {
            if (targetToValue.first instanceof PySubscriptionExpression) {
                PySubscriptionExpression subscriptionExpression = (PySubscriptionExpression)targetToValue.first;
                if (!name.equals(subscriptionExpression.getOperand().getName()) || subscriptionExpression.getIndexExpression() == null || PyDictCreationInspection.referencesTarget((PyExpression)targetToValue.second, (PsiElement)target)) continue;
                targets.add(targetToValue);
                continue;
            }
            return null;
        }
        return targets;
    }

    private static boolean referencesTarget(@NotNull PyExpression expression, final @NotNull PsiElement target) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/inspections/PyDictCreationInspection", "referencesTarget"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/python/inspections/PyDictCreationInspection", "referencesTarget"));
        }
        final ArrayList refs = new ArrayList();
        expression.accept(new PyRecursiveElementVisitor(){

            @Override
            public void visitPyReferenceExpression(PyReferenceExpression node) {
                super.visitPyReferenceExpression(node);
                PsiPolyVariantReference ref = node.getReference();
                if (ref.isReferenceTo(target)) {
                    refs.add(node);
                }
            }
        });
        return !refs.isEmpty();
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyDictCreationInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyAssignmentStatement(PyAssignmentStatement node) {
            if (node.getAssignedValue() instanceof PyDictLiteralExpression) {
                if (node.getTargets().length != 1) {
                    return;
                }
                PyExpression target = node.getTargets()[0];
                String name = target.getName();
                if (name == null) {
                    return;
                }
                PyStatement statement = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)node, PyStatement.class);
                while (statement instanceof PyAssignmentStatement) {
                    PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)statement;
                    List<Pair<PyExpression, PyExpression>> targets = PyDictCreationInspection.getDictTargets(target, name, assignmentStatement);
                    if (targets == null) {
                        return;
                    }
                    if (!targets.isEmpty()) {
                        this.registerProblem((PsiElement)node, "This dictionary creation could be rewritten as a dictionary literal", new DictCreationQuickFix(node));
                        break;
                    }
                    statement = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)assignmentStatement, PyStatement.class);
                }
            }
        }
    }
}

