/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyReferenceExpression;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDeprecationInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Deprecated function, class or module" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyDeprecationInspection", "getDisplayName"));
        }
        return "Deprecated function, class or module";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyDeprecationInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyDeprecationInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyDeprecationInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyDeprecationInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyReferenceExpression(PyReferenceExpression node) {
            PyExpression exceptClass;
            PyExceptPart exceptPart = (PyExceptPart)PsiTreeUtil.getParentOfType((PsiElement)node, PyExceptPart.class);
            if (exceptPart != null && (exceptClass = exceptPart.getExceptClass()) != null && "ImportError".equals(exceptClass.getText())) {
                return;
            }
            PsiPolyVariantReference reference = node.getReference(this.getResolveContext());
            if (reference == null) {
                return;
            }
            PsiElement resolveResult = reference.resolve();
            PyFromImportStatement importStatement = (PyFromImportStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PyFromImportStatement.class);
            if (importStatement != null) {
                PsiElement element = importStatement.resolveImportSource();
                if (resolveResult != null && element != resolveResult.getContainingFile()) {
                    return;
                }
            }
            String deprecationMessage = null;
            if (resolveResult instanceof PyFunction) {
                deprecationMessage = ((PyFunction)resolveResult).getDeprecationMessage();
            } else if (resolveResult instanceof PyFile) {
                deprecationMessage = ((PyFile)resolveResult).getDeprecationMessage();
            }
            if (deprecationMessage != null) {
                ASTNode nameElement = node.getNameElement();
                this.registerProblem((PsiElement)(nameElement == null ? node : nameElement.getPsi()), deprecationMessage, ProblemHighlightType.LIKE_DEPRECATED);
            }
        }
    }
}

