/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.RemoveDecoratorQuickFix;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyFunction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDecoratorInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.decorator.outside.class", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyDecoratorInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyDecoratorInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyDecoratorInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyDecoratorInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyDecoratorInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            PyClass containingClass = node.getContainingClass();
            if (containingClass != null) {
                return;
            }
            PyDecoratorList decorators = node.getDecoratorList();
            if (decorators == null) {
                return;
            }
            for (PyDecorator decorator : decorators.getDecorators()) {
                String name = decorator.getText();
                if (!name.equals("@classmethod") && !name.equals("@staticmethod")) continue;
                this.registerProblem((PsiElement)decorator, "Decorator " + name + " on method outside class", new RemoveDecoratorQuickFix());
            }
        }
    }
}

