/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.validation.CompatibilityVisitor;
import com.jetbrains.python.validation.UnsupportedFeaturesUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCompatibilityInspection
extends PyInspection {
    public JDOMExternalizableStringList ourVersions = new JDOMExternalizableStringList();

    public PyCompatibilityInspection() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.ourVersions.addAll(UnsupportedFeaturesUtil.ALL_LANGUAGE_LEVELS);
        }
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }

    private List<LanguageLevel> updateVersionsToProcess() {
        ArrayList<LanguageLevel> result = new ArrayList<LanguageLevel>();
        for (String version : this.ourVersions) {
            LanguageLevel level = LanguageLevel.fromPythonVersion(version);
            result.add(level);
        }
        return result;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.compatibility", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyCompatibilityInspection", "getDisplayName"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        JPanel versionPanel = new JPanel(new BorderLayout());
        final JBList list = new JBList(UnsupportedFeaturesUtil.ALL_LANGUAGE_LEVELS);
        JLabel label = new JLabel("Check for compatibility with python versions:");
        label.setLabelFor((Component)list);
        versionPanel.add((Component)label, "First");
        list.setSelectionMode(2);
        JBScrollPane scrollPane = new JBScrollPane((Component)list, 20, 31);
        versionPanel.add((Component)scrollPane);
        int[] indices = new int[this.ourVersions.size()];
        for (int i = 0; i != this.ourVersions.size(); ++i) {
            String s = (String)this.ourVersions.get(i);
            indices[i] = UnsupportedFeaturesUtil.ALL_LANGUAGE_LEVELS.indexOf(s);
        }
        list.setSelectedIndices(indices);
        list.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object o, int i, boolean b, boolean b2) {
                return super.getListCellRendererComponent((JList<?>)list, "Python " + o, i, b, b2);
            }
        });
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                PyCompatibilityInspection.this.ourVersions.clear();
                for (Object value : list.getSelectedValues()) {
                    PyCompatibilityInspection.this.ourVersions.add((Object)((String)value));
                }
            }
        });
        return versionPanel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyCompatibilityInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, this.updateVersionsToProcess());
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyCompatibilityInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends CompatibilityVisitor {
        private final ProblemsHolder myHolder;
        private Set<String> myUsedImports = Collections.synchronizedSet(new HashSet());

        public Visitor(ProblemsHolder holder, List<LanguageLevel> versionsToProcess) {
            super(versionsToProcess);
            this.myHolder = holder;
        }

        @Override
        protected final void registerProblem(@Nullable PsiElement element, @NotNull String message, @Nullable LocalQuickFix quickFix, boolean asError) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/python/inspections/PyCompatibilityInspection$Visitor", "registerProblem"));
            }
            if (element == null) {
                return;
            }
            this.registerProblem(element, element.getTextRange(), message, quickFix, asError);
        }

        @Override
        protected void registerProblem(@NotNull PsiElement element, @NotNull TextRange range, String message, @Nullable LocalQuickFix quickFix, boolean asError) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/inspections/PyCompatibilityInspection$Visitor", "registerProblem"));
            }
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/python/inspections/PyCompatibilityInspection$Visitor", "registerProblem"));
            }
            if (element.getTextLength() == 0) {
                return;
            }
            range = TextRange.create((int)(range.getStartOffset() - element.getTextOffset()), (int)(range.getEndOffset() - element.getTextOffset()));
            if (quickFix != null) {
                this.myHolder.registerProblem(element, range, message, new LocalQuickFix[]{quickFix});
            } else {
                this.myHolder.registerProblem(element, range, message, new LocalQuickFix[0]);
            }
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            super.visitPyCallExpression(node);
            int len = 0;
            StringBuilder message = new StringBuilder("Python version ");
            PyExpression callee = node.getCallee();
            assert (callee != null);
            PsiReference reference = callee.getReference();
            if (reference != null) {
                PsiElement resolved = reference.resolve();
                ProjectFileIndex ind = ProjectRootManager.getInstance((Project)callee.getProject()).getFileIndex();
                if (resolved instanceof PyFunction) {
                    LanguageLevel languageLevel;
                    int i;
                    String name = ((PyFunction)resolved).getName();
                    PyClass containingClass = ((PyFunction)resolved).getContainingClass();
                    if (containingClass != null) {
                        if ("__init__".equals(name)) {
                            name = callee.getText();
                        } else {
                            message = new StringBuilder("Class " + containingClass.getName() + " in python version ");
                        }
                        for (i = 0; i != this.myVersionsToProcess.size(); ++i) {
                            Map<LanguageLevel, Set<String>> map;
                            Set<String> unsupportedMethods;
                            languageLevel = (LanguageLevel)((Object)this.myVersionsToProcess.get(i));
                            if (!UnsupportedFeaturesUtil.CLASS_METHODS.containsKey(containingClass.getName()) || (unsupportedMethods = (map = UnsupportedFeaturesUtil.CLASS_METHODS.get(containingClass.getName())).get((Object)languageLevel)) == null || !unsupportedMethods.contains(name)) continue;
                            len = Visitor.appendLanguageLevel(message, len, languageLevel);
                        }
                    }
                    for (i = 0; i != this.myVersionsToProcess.size(); ++i) {
                        languageLevel = (LanguageLevel)((Object)this.myVersionsToProcess.get(i));
                        if (!PyBuiltinCache.getInstance(resolved).isBuiltin(resolved) || "print".equals(name) || this.myUsedImports.contains(name) || !UnsupportedFeaturesUtil.BUILTINS.get((Object)languageLevel).contains(name)) continue;
                        len = Visitor.appendLanguageLevel(message, len, languageLevel);
                    }
                    this.commonRegisterProblem(message, " not have method " + name, len, (PyElement)node, null, false);
                }
            }
        }

        @Override
        public void visitPyImportElement(PyImportElement importElement) {
            PyFromImportStatement fromImportStatement;
            this.myUsedImports.add(importElement.getVisibleName());
            PyIfStatement ifParent = (PyIfStatement)PsiTreeUtil.getParentOfType((PsiElement)importElement, PyIfStatement.class);
            if (ifParent != null) {
                return;
            }
            int len = 0;
            String moduleName = "";
            StringBuilder message = new StringBuilder("Python version ");
            PyTryExceptStatement tryExceptStatement = (PyTryExceptStatement)PsiTreeUtil.getParentOfType((PsiElement)importElement, PyTryExceptStatement.class);
            if (tryExceptStatement != null) {
                PyExceptPart[] parts;
                for (PyExceptPart part : parts = tryExceptStatement.getExceptParts()) {
                    PyExpression exceptClass = part.getExceptClass();
                    if (exceptClass == null || !exceptClass.getText().equals("ImportError")) continue;
                    return;
                }
            }
            if ((fromImportStatement = (PyFromImportStatement)PsiTreeUtil.getParentOfType((PsiElement)importElement, PyFromImportStatement.class)) != null) {
                for (int i = 0; i != this.myVersionsToProcess.size(); ++i) {
                    LanguageLevel languageLevel = (LanguageLevel)((Object)this.myVersionsToProcess.get(i));
                    QualifiedName qName = importElement.getImportedQName();
                    QualifiedName sourceQName = fromImportStatement.getImportSourceQName();
                    if (qName == null || sourceQName == null || !qName.matches(new String[]{"unicode_literals"}) || !sourceQName.matches(new String[]{"__future__"}) || !languageLevel.isOlderThan(LanguageLevel.PYTHON26)) continue;
                    len = Visitor.appendLanguageLevel(message, len, languageLevel);
                }
                this.commonRegisterProblem(message, " not have unicode_literals in __future__ module", len, importElement, null);
                return;
            }
            for (int i = 0; i != this.myVersionsToProcess.size(); ++i) {
                LanguageLevel languageLevel = (LanguageLevel)((Object)this.myVersionsToProcess.get(i));
                QualifiedName qName = importElement.getImportedQName();
                if (qName == null || qName.matches(new String[]{"builtins"}) || qName.matches(new String[]{"__builtin__"})) continue;
                moduleName = qName.toString();
                if (!UnsupportedFeaturesUtil.MODULES.get((Object)languageLevel).contains(moduleName)) continue;
                len = Visitor.appendLanguageLevel(message, len, languageLevel);
            }
            this.commonRegisterProblem(message, " not have module " + moduleName, len, importElement, null);
        }

        @Override
        public void visitPyFromImportStatement(PyFromImportStatement node) {
            super.visitPyFromImportStatement(node);
            if (node.getRelativeLevel() > 0) {
                return;
            }
            int len = 0;
            StringBuilder message = new StringBuilder("Python version ");
            QualifiedName name = node.getImportSourceQName();
            PyReferenceExpression source = node.getImportSource();
            if (name != null) {
                for (int i = 0; i != this.myVersionsToProcess.size(); ++i) {
                    LanguageLevel languageLevel = (LanguageLevel)((Object)this.myVersionsToProcess.get(i));
                    if (!UnsupportedFeaturesUtil.MODULES.get((Object)languageLevel).contains(name.toString())) continue;
                    len = Visitor.appendLanguageLevel(message, len, languageLevel);
                }
                this.commonRegisterProblem(message, " not have module " + name, len, (PyElement)source, null, false);
            }
        }

        @Override
        public void visitPyArgumentList(PyArgumentList node) {
            ArrayList<PyExpression> problemElements = new ArrayList<PyExpression>();
            if (node.getParent() instanceof PyClass) {
                for (PyExpression pyExpression : node.getArguments()) {
                    if (!(pyExpression instanceof PyKeywordArgument)) continue;
                    problemElements.add(pyExpression);
                }
            }
            String errorMessage = "This syntax available only since py3";
            boolean isPy3 = LanguageLevel.forElement((PsiElement)node).isPy3K();
            if (this.shouldBeCompatibleWithPy2() || !isPy3) {
                for (PyElement pyElement : problemElements) {
                    this.myHolder.registerProblem((PsiElement)pyElement, "This syntax available only since py3", isPy3 ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
                }
            }
        }

        @Override
        public void visitPyReferenceExpression(PyReferenceExpression node) {
            super.visitPyElement(node);
            if (this.shouldBeCompatibleWithPy3()) {
                PsiElement res;
                PyExpression qualifier;
                TypeEvalContext context = TypeEvalContext.codeAnalysis(node.getProject(), node.getContainingFile());
                String nodeText = node.getText();
                if ((nodeText.endsWith("iteritems") || nodeText.endsWith("iterkeys") || nodeText.endsWith("itervalues")) && (qualifier = node.getQualifier()) != null) {
                    PyType type = context.getType(qualifier);
                    PyClassType dictType = PyBuiltinCache.getInstance((PsiElement)node).getDictType();
                    if (PyTypeChecker.match(dictType, type, context)) {
                        this.registerProblem((PsiElement)node, "dict.iterkeys(), dict.iteritems() and dict.itervalues() methods are not available in py3");
                    }
                }
                if ("basestring".equals(nodeText) && (res = node.getReference().resolve()) != null) {
                    ProjectFileIndex ind = ProjectRootManager.getInstance((Project)node.getProject()).getFileIndex();
                    PsiFile file = res.getContainingFile();
                    if (file != null) {
                        VirtualFile virtualFile = file.getVirtualFile();
                        if (virtualFile != null && ind.isInLibraryClasses(virtualFile)) {
                            this.registerProblem((PsiElement)node, "basestring type is not available in py3");
                        }
                    } else {
                        this.registerProblem((PsiElement)node, "basestring type is not available in py3");
                    }
                }
            }
        }
    }
}

