/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.ComparisonWithNoneQuickFix;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyComparisonWithNoneInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.comparison.with.none", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyComparisonWithNoneInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyComparisonWithNoneInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyComparisonWithNoneInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyComparisonWithNoneInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyComparisonWithNoneInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyBinaryExpression(PyBinaryExpression node) {
            PyElementType operator;
            PyExpression rightExpression = node.getRightExpression();
            if ((rightExpression instanceof PyReferenceExpression && "None".equals(rightExpression.getText()) || rightExpression instanceof PyNoneLiteralExpression) && ((operator = node.getOperator()) == PyTokenTypes.EQEQ || operator == PyTokenTypes.NE || operator == PyTokenTypes.NE_OLD)) {
                PsiReference reference = node.getReference();
                assert (reference != null);
                PsiElement result = reference.resolve();
                if (result == null || PyBuiltinCache.getInstance((PsiElement)node).isBuiltin(result)) {
                    this.registerProblem((PsiElement)node, "Comparison with None performed with equality operators", new ComparisonWithNoneQuickFix());
                }
            }
        }
    }
}

