/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.TransformClassicClassQuickFix;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyClassicStyleClassInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.classic.class.usage", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyClassicStyleClassInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyClassicStyleClassInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyClassicStyleClassInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyClassicStyleClassInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyClassicStyleClassInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyClass(PyClass node) {
            ASTNode nameNode = node.getNameNode();
            if (!node.isNewStyleClass() && nameNode != null) {
                PyExpression[] superClassExpressions = node.getSuperClassExpressions();
                if (superClassExpressions.length == 0) {
                    this.registerProblem(nameNode.getPsi(), "Old-style class", new TransformClassicClassQuickFix());
                } else {
                    this.registerProblem(nameNode.getPsi(), "Old-style class, because all classes from whom it inherits are old-style");
                }
            }
        }
    }
}

