/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AddMethodQuickFix;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyClassHasNoInitInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.class.has.no.init", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyClassHasNoInitInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyClassHasNoInitInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyClassHasNoInitInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyClassHasNoInitInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyClassHasNoInitInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyClass(PyClass node) {
            PyClass outerClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)node, PyClass.class);
            assert (node != null);
            if (outerClass != null && StringUtil.equalsIgnoreCase((CharSequence)"meta", (CharSequence)node.getName())) {
                return;
            }
            List<PyClassLikeType> types = node.getAncestorTypes(this.myTypeEvalContext);
            for (PyClassLikeType type : types) {
                if (type == null) {
                    return;
                }
                String qName = type.getClassQName();
                if (qName != null && qName.contains("TestCase")) {
                    return;
                }
                if (type instanceof PyClassType) continue;
                return;
            }
            PyFunction init = node.findInitOrNew(true);
            if (init == null) {
                this.registerProblem(node.getNameIdentifier(), PyBundle.message("INSP.class.has.no.init", new Object[0]), new AddMethodQuickFix("__init__", node.getName(), false));
            }
        }
    }
}

