/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.ChainedComparisonsQuickFix;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyChainedComparisonsInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.chained.comparisons", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyChainedComparisonsInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyChainedComparisonsInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyChainedComparisonsInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyChainedComparisonsInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        boolean myIsLeft;
        boolean myIsRight;
        PyElementType myOperator;
        boolean getInnerRight;

        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyChainedComparisonsInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyBinaryExpression(PyBinaryExpression node) {
            this.myIsLeft = false;
            this.myIsRight = false;
            this.myOperator = null;
            this.getInnerRight = false;
            PyExpression leftExpression = node.getLeftExpression();
            PyExpression rightExpression = node.getRightExpression();
            if (leftExpression instanceof PyBinaryExpression && rightExpression instanceof PyBinaryExpression && node.getOperator() == PyTokenTypes.AND_KEYWORD && (this.isRightSimplified((PyBinaryExpression)leftExpression, (PyBinaryExpression)rightExpression) || this.isLeftSimplified((PyBinaryExpression)leftExpression, (PyBinaryExpression)rightExpression))) {
                this.registerProblem((PsiElement)node, "Simplify chained comparison", new ChainedComparisonsQuickFix(this.myIsLeft, this.myIsRight, this.getInnerRight));
            }
        }

        private boolean isRightSimplified(@NotNull PyBinaryExpression leftExpression, @NotNull PyBinaryExpression rightExpression) {
            if (leftExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftExpression", "com/jetbrains/python/inspections/PyChainedComparisonsInspection$Visitor", "isRightSimplified"));
            }
            if (rightExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightExpression", "com/jetbrains/python/inspections/PyChainedComparisonsInspection$Visitor", "isRightSimplified"));
            }
            PyExpression leftRight = leftExpression.getRightExpression();
            if (leftRight instanceof PyBinaryExpression && PyTokenTypes.AND_KEYWORD == leftExpression.getOperator() && this.isRightSimplified((PyBinaryExpression)leftRight, rightExpression)) {
                this.getInnerRight = true;
                return true;
            }
            if (leftRight instanceof PyBinaryExpression && PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)((PyBinaryExpression)leftRight).getOperator()) && this.isRightSimplified((PyBinaryExpression)leftRight, rightExpression)) {
                return true;
            }
            this.myOperator = leftExpression.getOperator();
            if (PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)this.myOperator) && leftRight != null) {
                if (leftRight.getText().equals(this.getLeftExpression(rightExpression, true).getText())) {
                    this.myIsLeft = false;
                    this.myIsRight = true;
                    return true;
                }
                PyExpression right = this.getSmallestRight(rightExpression, true);
                if (right != null && leftRight.getText().equals(right.getText())) {
                    this.myIsLeft = false;
                    this.myIsRight = false;
                    return true;
                }
            }
            return false;
        }

        private static boolean isOpposite(PyElementType op1, PyElementType op2) {
            if (!(op1 != PyTokenTypes.GT && op1 != PyTokenTypes.GE || op2 != PyTokenTypes.LT && op2 != PyTokenTypes.LE)) {
                return true;
            }
            return !(op2 != PyTokenTypes.GT && op2 != PyTokenTypes.GE || op1 != PyTokenTypes.LT && op1 != PyTokenTypes.LE);
        }

        private boolean isLeftSimplified(PyBinaryExpression leftExpression, PyBinaryExpression rightExpression) {
            PyExpression leftLeft = leftExpression.getLeftExpression();
            PyExpression leftRight = leftExpression.getRightExpression();
            if (leftRight instanceof PyBinaryExpression && PyTokenTypes.AND_KEYWORD == leftExpression.getOperator() && this.isLeftSimplified((PyBinaryExpression)leftRight, rightExpression)) {
                this.getInnerRight = true;
                return true;
            }
            if (leftLeft instanceof PyBinaryExpression && PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)((PyBinaryExpression)leftLeft).getOperator()) && this.isLeftSimplified((PyBinaryExpression)leftLeft, rightExpression)) {
                return true;
            }
            this.myOperator = leftExpression.getOperator();
            if (PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)this.myOperator) && leftLeft != null) {
                if (leftLeft.getText().equals(this.getLeftExpression(rightExpression, false).getText())) {
                    this.myIsLeft = true;
                    this.myIsRight = true;
                    return true;
                }
                PyExpression right = this.getSmallestRight(rightExpression, false);
                if (right != null && leftLeft.getText().equals(right.getText())) {
                    this.myIsLeft = true;
                    this.myIsRight = false;
                    return true;
                }
            }
            return false;
        }

        private PyExpression getLeftExpression(PyBinaryExpression expression, boolean isRight) {
            PyExpression result = expression;
            while (result instanceof PyBinaryExpression && (PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)result.getOperator()) || PyTokenTypes.EQUALITY_OPERATIONS.contains((IElementType)result.getOperator()))) {
                boolean opposite = Visitor.isOpposite(result.getOperator(), this.myOperator);
                if (isRight && opposite || !isRight && !opposite) break;
                result = result.getLeftExpression();
            }
            return result;
        }

        @Nullable
        private PyExpression getSmallestRight(PyBinaryExpression expression, boolean isRight) {
            PyExpression result = expression;
            while (result instanceof PyBinaryExpression && (PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)result.getOperator()) || PyTokenTypes.EQUALITY_OPERATIONS.contains((IElementType)result.getOperator()))) {
                boolean opposite = Visitor.isOpposite(result.getOperator(), this.myOperator);
                if (isRight && !opposite || !isRight && opposite) break;
                result = result.getRightExpression();
            }
            return result;
        }
    }
}

