/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyRemoveCallQuickFix;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCallingNonCallableInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Trying to call a non-callable object" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyCallingNonCallableInspection", "getDisplayName"));
        }
        return "Trying to call a non-callable object";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyCallingNonCallableInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyCallingNonCallableInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyCallingNonCallableInspection", "buildVisitor"));
        }
        return visitor;
    }

    @Nullable
    private static Boolean isCallable(@NotNull PyExpression element, @NotNull TypeEvalContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/inspections/PyCallingNonCallableInspection", "isCallable"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/inspections/PyCallingNonCallableInspection", "isCallable"));
        }
        if (element instanceof PyQualifiedExpression && "__class__".equals(element.getName())) {
            return true;
        }
        return PyTypeChecker.isCallable(context.getType(element));
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyCallingNonCallableInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            super.visitPyCallExpression(node);
            this.checkCallable(node, node.getCallee(), null);
        }

        @Override
        public void visitPyDecoratorList(PyDecoratorList node) {
            super.visitPyDecoratorList(node);
            for (PyDecorator decorator : node.getDecorators()) {
                PyExpression callee = decorator.getCallee();
                this.checkCallable(decorator, callee, null);
                if (!decorator.hasArgumentList()) continue;
                this.checkCallable(decorator, decorator, null);
            }
        }

        private void checkCallable(@NotNull PyElement node, @Nullable PyExpression callee, @Nullable PyType type) {
            Boolean callable;
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/inspections/PyCallingNonCallableInspection$Visitor", "checkCallable"));
            }
            Boolean bl = callable = callee != null ? PyCallingNonCallableInspection.isCallable(callee, this.myTypeEvalContext) : PyTypeChecker.isCallable(type);
            if (callable == null) {
                return;
            }
            if (!callable.booleanValue()) {
                String name;
                PyType calleeType = callee != null ? this.myTypeEvalContext.getType(callee) : type;
                String message = "Expression is not callable";
                if (calleeType instanceof PyClassType) {
                    message = String.format("'%s' object is not callable", calleeType.getName());
                } else if (callee != null && (name = callee.getName()) != null) {
                    message = String.format("'%s' is not callable", name);
                }
                this.registerProblem((PsiElement)node, message, new PyRemoveCallQuickFix());
            }
        }
    }
}

