/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.CallArgumentsMapping;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyCallByClassInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.different.class.call", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyCallByClassInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyCallByClassInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyCallByClassInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyCallByClassInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyCallByClassInspection", "buildVisitor"));
        }
        return visitor;
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(ProblemsHolder holder, LocalInspectionToolSession session) {
            super(holder, session);
        }

        @Override
        public void visitPyCallExpression(PyCallExpression call) {
            PyClassType qual_class_type;
            PyType qual_type;
            PyExpression qualifier;
            PyExpression callee = call.getCallee();
            if (callee instanceof PyQualifiedExpression && (qualifier = ((PyQualifiedExpression)callee).getQualifier()) != null && (qual_type = this.myTypeEvalContext.getType(qualifier)) instanceof PyClassType && (qual_class_type = (PyClassType)qual_type).isDefinition()) {
                List<PyParameter> params;
                CallArgumentsMapping analysis;
                PyCallExpression.PyMarkedCallee markedCallee;
                PyClass qual_class = qual_class_type.getPyClass();
                PyArgumentList arglist = call.getArgumentList();
                if (arglist != null && (markedCallee = (analysis = arglist.analyzeCall(this.getResolveContext())).getMarkedCallee()) != null && markedCallee.getModifier() != PyFunction.Modifier.STATICMETHOD && (params = PyUtil.getParameters(markedCallee.getCallable(), this.myTypeEvalContext)).size() > 0 && params.get(0) instanceof PyNamedParameter) {
                    PyNamedParameter first_param = (PyNamedParameter)params.get(0);
                    for (Map.Entry<PyExpression, PyNamedParameter> entry : analysis.getPlainMappedParams().entrySet()) {
                        PyFunction method;
                        Callable callable;
                        PyClass first_arg_class;
                        if (entry.getValue() != first_param) continue;
                        PyExpression first_arg = entry.getKey();
                        assert (first_arg != null);
                        PyType first_arg_type = this.myTypeEvalContext.getType(first_arg);
                        if (!(first_arg_type instanceof PyClassType)) break;
                        PyClassType first_arg_class_type = (PyClassType)first_arg_type;
                        if (first_arg_class_type.isDefinition() && markedCallee.getModifier() != PyFunction.Modifier.CLASSMETHOD) {
                            this.registerProblem((PsiElement)first_arg, PyBundle.message("INSP.instance.of.$0.excpected", qual_class.getQualifiedName()));
                        }
                        if ((first_arg_class = first_arg_class_type.getPyClass()) == qual_class) break;
                        if (markedCallee.getCallable() instanceof PyFunction && (callable = (Callable)PsiTreeUtil.getParentOfType((PsiElement)call, Callable.class)) != null && (method = callable.asMethod()) != null) {
                            PyClass calling_class = method.getContainingClass();
                            assert (calling_class != null);
                            if (first_arg_class.isSubclass(qual_class) && calling_class.isSubclass(qual_class)) break;
                        }
                        this.registerProblem((PsiElement)first_arg, PyBundle.message("INSP.passing.$0.instead.of.$1", first_arg_class.getQualifiedName(), qual_class.getQualifiedName()));
                        break;
                    }
                }
            }
        }
    }
}

