/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyByteLiteralInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.byte.literal", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyByteLiteralInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyByteLiteralInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyByteLiteralInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyByteLiteralInspection", "buildVisitor"));
        }
        return visitor;
    }

    private class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyByteLiteralInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        public void visitComment(PsiComment node) {
            this.checkString((PsiElement)node, node.getText());
        }

        private void checkString(PsiElement node, String value) {
            char first_char;
            boolean isByte;
            PsiFile file = node.getContainingFile();
            if (file == null) {
                return;
            }
            boolean default_bytes = false;
            if (file instanceof PyFile) {
                PyFile pyfile = (PyFile)file;
                default_bytes = !FutureFeature.UNICODE_LITERALS.requiredAt(pyfile.getLanguageLevel()) && !pyfile.hasImportFromFuture(FutureFeature.UNICODE_LITERALS);
            }
            String charsetString = PythonFileType.getCharsetFromEncodingDeclaration(file);
            try {
                if (charsetString != null && !Charset.forName(charsetString).equals(Charset.forName("US-ASCII"))) {
                    default_bytes = false;
                }
            }
            catch (UnsupportedCharsetException exception) {
            }
            catch (IllegalCharsetNameException e) {
                // empty catch block
            }
            boolean hasNonAscii = false;
            int length = value.length();
            char c = '\u0000';
            for (int i = 0; i < length; ++i) {
                c = value.charAt(i);
                if (c <= '\u00ff') continue;
                hasNonAscii = true;
                break;
            }
            boolean bl = isByte = (first_char = Character.toLowerCase(node.getText().charAt(0))) == 'b' || default_bytes && first_char != 'u';
            if (hasNonAscii && isByte) {
                this.registerProblem(node, "Byte literal contains characters > 255");
            }
        }

        @Override
        public void visitPyStringLiteralExpression(PyStringLiteralExpression node) {
            this.checkString(node, node.getStringValue());
        }
    }
}

