/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.Stack;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyBroadExceptionInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.too.broad.exception.clauses", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyBroadExceptionInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyBroadExceptionInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyBroadExceptionInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyBroadExceptionInspection", "buildVisitor"));
        }
        return visitor;
    }

    public static boolean equalsException(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        if (cls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "com/jetbrains/python/inspections/PyBroadExceptionInspection", "equalsException"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/inspections/PyBroadExceptionInspection", "equalsException"));
        }
        PyType type = context.getType(cls);
        return ("Exception".equals(cls.getName()) || "BaseException".equals(cls.getName())) && type != null && type.isBuiltin();
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyBroadExceptionInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyExceptBlock(PyExceptPart node) {
            PyType type;
            PyExpression exceptClass = node.getExceptClass();
            if (Visitor.reRaised(node)) {
                return;
            }
            if (exceptClass == null) {
                this.registerProblem(node.getFirstChild(), "Too broad exception clause");
            }
            if (exceptClass != null && (type = this.myTypeEvalContext.getType(exceptClass)) instanceof PyClassType) {
                PyClass cls = ((PyClassType)type).getPyClass();
                PyExpression target = node.getTarget();
                if (PyBroadExceptionInspection.equalsException(cls, this.myTypeEvalContext) && (target == null || !Visitor.isExceptionUsed(node, target.getText()))) {
                    this.registerProblem((PsiElement)exceptClass, "Too broad exception clause");
                }
            }
        }

        private static boolean reRaised(PyExceptPart node) {
            PyStatementList statementList = node.getStatementList();
            if (statementList != null) {
                for (PyStatement st : statementList.getStatements()) {
                    if (!(st instanceof PyRaiseStatement)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isExceptionUsed(PyExceptPart node, String text) {
            Stack stack = new Stack();
            PyStatementList statementList = node.getStatementList();
            if (statementList != null) {
                for (PyStatement st : statementList.getStatements()) {
                    stack.push((Object)st);
                    while (!stack.isEmpty()) {
                        PsiElement resolved;
                        PsiReference reference;
                        PsiElement e = (PsiElement)stack.pop();
                        if (e instanceof PyReferenceExpression && (reference = e.getReference()) != null && (resolved = reference.resolve()) != null && resolved.getText().equals(text)) {
                            return true;
                        }
                        for (PsiElement psiElement : e.getChildren()) {
                            stack.push((Object)psiElement);
                        }
                    }
                }
            }
            return false;
        }
    }
}

