/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AugmentedAssignmentQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyAugmentAssignmentInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.augment.assignment", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyAugmentAssignmentInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyAugmentAssignmentInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyAugmentAssignmentInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyAugmentAssignmentInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyAugmentAssignmentInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyAssignmentStatement(PyAssignmentStatement node) {
            PyExpression value = node.getAssignedValue();
            if (value instanceof PyBinaryExpression) {
                PyType type;
                PyExpression target = node.getLeftHandSideExpression();
                PyBinaryExpression expression = (PyBinaryExpression)value;
                PyExpression leftExpression = expression.getLeftExpression();
                PyExpression rightExpression = expression.getRightExpression();
                if (rightExpression instanceof PyParenthesizedExpression) {
                    rightExpression = ((PyParenthesizedExpression)rightExpression).getContainedExpression();
                }
                if (rightExpression == null || target == null) {
                    return;
                }
                boolean changedParts = false;
                String targetText = target.getText();
                String rightText = rightExpression.getText();
                if (rightText.equals(targetText)) {
                    PyExpression tmp = rightExpression;
                    rightExpression = leftExpression;
                    leftExpression = tmp;
                    changedParts = true;
                }
                PyElementType op = expression.getOperator();
                TokenSet operations = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.PLUS, PyTokenTypes.MINUS, PyTokenTypes.MULT, PyTokenTypes.FLOORDIV, PyTokenTypes.DIV, PyTokenTypes.PERC, PyTokenTypes.AND, PyTokenTypes.OR, PyTokenTypes.XOR, PyTokenTypes.LTLT, PyTokenTypes.GTGT, PyTokenTypes.EXP});
                TokenSet commutativeOperations = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.PLUS, PyTokenTypes.MULT, PyTokenTypes.OR, PyTokenTypes.AND});
                if ((operations.contains((IElementType)op) && !changedParts || changedParts && commutativeOperations.contains((IElementType)op)) && leftExpression.getText().equals(targetText) && (leftExpression instanceof PyReferenceExpression || leftExpression instanceof PySubscriptionExpression) && (type = this.myTypeEvalContext.getType(rightExpression)) != null && !PyTypeChecker.isUnknown(type)) {
                    PyBuiltinCache cache = PyBuiltinCache.getInstance((PsiElement)rightExpression);
                    LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)rightExpression);
                    if (this.isNumeric(type, cache) || this.isString(type, cache, languageLevel) && !changedParts) {
                        this.registerProblem((PsiElement)node, "Assignment can be replaced with augmented assignment", new AugmentedAssignmentQuickFix());
                    }
                }
            }
        }

        private boolean isString(PyType type, PyBuiltinCache cache, LanguageLevel level) {
            return PyTypeChecker.match(cache.getStringType(level), type, this.myTypeEvalContext);
        }

        private boolean isNumeric(PyType type, PyBuiltinCache cache) {
            return PyTypeChecker.match(cache.getComplexType(), type, this.myTypeEvalContext);
        }
    }
}

