/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyMoveAttributeToInitQuickFix;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyClassImpl;
import com.jetbrains.python.testing.PythonUnitTestUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyAttributeOutsideInitInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.attribute.outside.init", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyAttributeOutsideInitInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyAttributeOutsideInitInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyAttributeOutsideInitInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyAttributeOutsideInitInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static boolean isApplicable(@NotNull PyClass containingClass) {
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/jetbrains/python/inspections/PyAttributeOutsideInitInspection", "isApplicable"));
        }
        return !PythonUnitTestUtil.isUnitTestCaseClass(containingClass) && !containingClass.isSubclass("django.db.models.base.Model");
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyAttributeOutsideInitInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            PyClass containingClass = node.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String name = node.getName();
            if (name != null && name.startsWith("_")) {
                return;
            }
            if (!PyAttributeOutsideInitInspection.isApplicable(containingClass)) {
                return;
            }
            PyFunction.Modifier modifier = node.getModifier();
            if (modifier != null) {
                return;
            }
            List<PyTargetExpression> classAttributes = containingClass.getClassAttributes();
            HashMap<String, PyTargetExpression> attributesInInit = new HashMap<String, PyTargetExpression>();
            for (PyTargetExpression classAttr : classAttributes) {
                attributesInInit.put(classAttr.getName(), classAttr);
            }
            PyFunction initMethod = containingClass.findMethodByName("__init__", false);
            if (initMethod != null) {
                PyClassImpl.collectInstanceAttributes(initMethod, attributesInInit);
            }
            for (PyClass superClass : containingClass.getAncestorClasses(this.myTypeEvalContext)) {
                PyFunction superInit = superClass.findMethodByName("__init__", false);
                if (superInit != null) {
                    PyClassImpl.collectInstanceAttributes(superInit, attributesInInit);
                }
                for (PyTargetExpression classAttr : superClass.getClassAttributes()) {
                    attributesInInit.put(classAttr.getName(), classAttr);
                }
            }
            HashMap<String, PyTargetExpression> attributes = new HashMap<String, PyTargetExpression>();
            PyClassImpl.collectInstanceAttributes(node, attributes);
            for (Map.Entry attribute : attributes.entrySet()) {
                String attributeName = (String)attribute.getKey();
                if (attributeName == null) continue;
                Property property = containingClass.findProperty(attributeName, true);
                if (attributesInInit.containsKey(attributeName) || property != null) continue;
                this.registerProblem((PsiElement)attribute.getValue(), PyBundle.message("INSP.attribute.$0.outside.init", attributeName), new PyMoveAttributeToInitQuickFix());
            }
        }
    }
}

