/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.NameDefiner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElsePart;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithStatement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyAssignmentToLoopOrWithParameterInspection
extends PyInspection {
    private static final String NAME = PyBundle.message("INSP.NAME.assignment.to.loop.or.with.parameter.display.name", new Object[0]);

    @NotNull
    public String getDisplayName() {
        String string = NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyAssignmentToLoopOrWithParameterInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyAssignmentToLoopOrWithParameterInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyAssignmentToLoopOrWithParameterInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyAssignmentToLoopOrWithParameterInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static boolean isDeclaredInElse(@NotNull PsiElement elementToCheck, @NotNull PyForStatement forStatement) {
        if (elementToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToCheck", "com/jetbrains/python/inspections/PyAssignmentToLoopOrWithParameterInspection", "isDeclaredInElse"));
        }
        if (forStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forStatement", "com/jetbrains/python/inspections/PyAssignmentToLoopOrWithParameterInspection", "isDeclaredInElse"));
        }
        PyElsePart elsePart = forStatement.getElsePart();
        return elsePart != null && PsiTreeUtil.isAncestor((PsiElement)elsePart, (PsiElement)elementToCheck, (boolean)false);
    }

    private static PsiElement handleSubscriptionsAndResolveSafely(PsiElement element) {
        assert (element != null);
        if (element instanceof PySubscriptionExpression) {
            element = ((PySubscriptionExpression)element).getRootOperand();
        }
        element = PyUtil.resolveToTheTop(element);
        return element;
    }

    private static boolean isRequiredStatement(PsiElement element) {
        assert (element != null);
        return element instanceof PyWithStatement || element instanceof PyForStatement;
    }

    private static class Filter
    implements Condition<PsiElement> {
        private final PsiElement myNode;

        private Filter(PsiElement node) {
            this.myNode = node;
        }

        public boolean value(PsiElement psiElement) {
            if (psiElement instanceof ScopeOwner) {
                return true;
            }
            if (!PyAssignmentToLoopOrWithParameterInspection.isRequiredStatement(psiElement)) {
                return false;
            }
            Iterable<PyElement> varsDeclaredInStatement = ((NameDefiner)psiElement).iterateNames();
            for (PyElement varDeclaredInStatement : varsDeclaredInStatement) {
                PsiReference reference = PyAssignmentToLoopOrWithParameterInspection.handleSubscriptionsAndResolveSafely((PsiElement)varDeclaredInStatement).getReference();
                if (reference == null || !reference.isReferenceTo(this.myNode)) continue;
                return true;
            }
            return false;
        }
    }

    private static class Visitor
    extends PyInspectionVisitor {
        private Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyAssignmentToLoopOrWithParameterInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyWithStatement(PyWithStatement node) {
            this.checkNotReDeclaringUpperLoopOrStatement(node);
        }

        @Override
        public void visitPyForStatement(PyForStatement node) {
            this.checkNotReDeclaringUpperLoopOrStatement(node);
        }

        private void checkNotReDeclaringUpperLoopOrStatement(@NotNull NameDefiner statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/jetbrains/python/inspections/PyAssignmentToLoopOrWithParameterInspection$Visitor", "checkNotReDeclaringUpperLoopOrStatement"));
            }
            for (PyElement declaredVar : statement.iterateNames()) {
                Filter filter = new Filter(PyAssignmentToLoopOrWithParameterInspection.handleSubscriptionsAndResolveSafely((PsiElement)declaredVar));
                PsiElement firstParent = PsiTreeUtil.findFirstParent((PsiElement)statement, (boolean)true, (Condition)filter);
                if (firstParent == null || !PyAssignmentToLoopOrWithParameterInspection.isRequiredStatement(firstParent) || firstParent instanceof PyForStatement && PyAssignmentToLoopOrWithParameterInspection.isDeclaredInElse(statement, (PyForStatement)firstParent)) continue;
                this.registerProblem((PsiElement)declaredVar, PyBundle.message("INSP.NAME.assignment.to.loop.or.with.parameter.display.message", declaredVar.getText()));
            }
        }
    }
}

