/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.Lists;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyRemoveArgumentQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRenameArgumentQuickFix;
import com.jetbrains.python.psi.CallArgumentsMapping;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyArgumentListInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.incorrect.call.arguments", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyArgumentListInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyArgumentListInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyArgumentListInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyArgumentListInspection", "buildVisitor"));
        }
        return visitor;
    }

    public static void inspectPyArgumentList(PyArgumentList node, ProblemsHolder holder, TypeEvalContext context, int implicitOffset) {
        Callable callable;
        if (node.getParent() instanceof PyClass) {
            return;
        }
        CallArgumentsMapping result = node.analyzeCall(PyResolveContext.noImplicits().withTypeEvalContext(context), implicitOffset);
        PyCallExpression.PyMarkedCallee callee = result.getMarkedCallee();
        if (callee != null && (callable = callee.getCallable()) instanceof PyFunction && PyUtil.hasCustomDecorators((PyFunction)callable)) {
            return;
        }
        PyArgumentListInspection.highlightIncorrectArguments(holder, result, context);
        PyArgumentListInspection.highlightMissingArguments(node, holder, result);
        PyArgumentListInspection.highlightStarArgumentTypeMismatch(node, holder, context);
    }

    public static void inspectPyArgumentList(PyArgumentList node, ProblemsHolder holder, TypeEvalContext context) {
        PyArgumentListInspection.inspectPyArgumentList(node, holder, context, 0);
    }

    private static void highlightIncorrectArguments(ProblemsHolder holder, CallArgumentsMapping result, @NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/inspections/PyArgumentListInspection", "highlightIncorrectArguments"));
        }
        for (Map.Entry<PyExpression, EnumSet<CallArgumentsMapping.ArgFlag>> argEntry : result.getArgumentFlags().entrySet()) {
            EnumSet<CallArgumentsMapping.ArgFlag> flags = argEntry.getValue();
            if (flags.isEmpty()) continue;
            PyExpression arg = argEntry.getKey();
            if (flags.contains((Object)CallArgumentsMapping.ArgFlag.IS_DUP)) {
                holder.registerProblem((PsiElement)arg, PyBundle.message("INSP.duplicate.argument", new Object[0]), new LocalQuickFix[]{new PyRemoveArgumentQuickFix()});
            }
            if (flags.contains((Object)CallArgumentsMapping.ArgFlag.IS_DUP_KWD)) {
                holder.registerProblem((PsiElement)arg, PyBundle.message("INSP.duplicate.doublestar.arg", new Object[0]), new LocalQuickFix[]{new PyRemoveArgumentQuickFix()});
            }
            if (flags.contains((Object)CallArgumentsMapping.ArgFlag.IS_DUP_TUPLE)) {
                holder.registerProblem((PsiElement)arg, PyBundle.message("INSP.duplicate.star.arg", new Object[0]), new LocalQuickFix[]{new PyRemoveArgumentQuickFix()});
            }
            if (flags.contains((Object)CallArgumentsMapping.ArgFlag.IS_POS_PAST_KWD)) {
                holder.registerProblem((PsiElement)arg, PyBundle.message("INSP.cannot.appear.past.keyword.arg", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[]{new PyRemoveArgumentQuickFix()});
            }
            if (flags.contains((Object)CallArgumentsMapping.ArgFlag.IS_UNMAPPED)) {
                ArrayList quickFixes = Lists.newArrayList((Object[])new LocalQuickFix[]{new PyRemoveArgumentQuickFix()});
                if (arg instanceof PyKeywordArgument) {
                    quickFixes.add(new PyRenameArgumentQuickFix());
                }
                holder.registerProblem((PsiElement)arg, PyBundle.message("INSP.unexpected.arg", new Object[0]), quickFixes.toArray(new LocalQuickFix[quickFixes.size() - 1]));
            }
            if (!flags.contains((Object)CallArgumentsMapping.ArgFlag.IS_TOO_LONG)) continue;
            PyCallExpression.PyMarkedCallee markedCallee = result.getMarkedCallee();
            String parameterName = null;
            if (markedCallee == null) continue;
            List<PyParameter> parameters = PyUtil.getParameters(markedCallee.getCallable(), context);
            for (int i = parameters.size() - 1; i >= 0; --i) {
                PyParameter param = parameters.get(i);
                if (!(param instanceof PyNamedParameter)) continue;
                List<PyNamedParameter> unmappedParams = result.getUnmappedParams();
                if (((PyNamedParameter)param).isPositionalContainer() || ((PyNamedParameter)param).isKeywordContainer() || param.getDefaultValue() != null || unmappedParams.contains(param)) continue;
                parameterName = param.getName();
                break;
            }
            holder.registerProblem((PsiElement)arg, parameterName != null ? PyBundle.message("INSP.multiple.values.resolve.to.positional.$0", parameterName) : PyBundle.message("INSP.more.args.that.pos.params", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void highlightStarArgumentTypeMismatch(PyArgumentList node, ProblemsHolder holder, TypeEvalContext context) {
        for (PyExpression arg : node.getArguments()) {
            PyType inside_type;
            PyExpression content;
            if (!(arg instanceof PyStarArgument) || (content = PyUtil.peelArgument((PyExpression)PsiTreeUtil.findChildOfType((PsiElement)arg, PyExpression.class))) == null || (inside_type = context.getType(content)) == null || PyTypeChecker.isUnknown(inside_type)) continue;
            if (((PyStarArgument)arg).isKeyword()) {
                if (PyABCUtil.isSubtype(inside_type, "Mapping", context)) continue;
                holder.registerProblem((PsiElement)arg, PyBundle.message("INSP.expected.dict.got.$0", inside_type.getName()), new LocalQuickFix[0]);
                continue;
            }
            if (PyABCUtil.isSubtype(inside_type, "Iterable", context)) continue;
            holder.registerProblem((PsiElement)arg, PyBundle.message("INSP.expected.iter.got.$0", inside_type.getName()), new LocalQuickFix[0]);
        }
    }

    private static void highlightMissingArguments(PyArgumentList node, ProblemsHolder holder, CallArgumentsMapping result) {
        ASTNode close_paren;
        ASTNode our_node = node.getNode();
        if (our_node != null && (close_paren = our_node.findChildByType((IElementType)PyTokenTypes.RPAR)) != null) {
            for (PyNamedParameter param : result.getUnmappedParams()) {
                holder.registerProblem(close_paren.getPsi(), PyBundle.message("INSP.parameter.$0.unfilled", param.getName()), new LocalQuickFix[0]);
            }
        }
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(ProblemsHolder holder, LocalInspectionToolSession session) {
            super(holder, session);
        }

        @Override
        public void visitPyArgumentList(PyArgumentList node) {
            PyArgumentListInspection.inspectPyArgumentList(node, this.getHolder(), this.myTypeEvalContext);
        }

        @Override
        public void visitPyDecoratorList(PyDecoratorList node) {
            PyDecorator[] decorators;
            for (PyDecorator deco : decorators = node.getDecorators()) {
                PyNamedParameter allegedFirstParam;
                PyCallExpression.PyMarkedCallee markedCallee;
                if (deco.hasArgumentList() || (markedCallee = deco.resolveCallee(this.getResolveContext())) == null || markedCallee.isImplicitlyResolved()) continue;
                Callable callable = markedCallee.getCallable();
                int firstParamOffset = markedCallee.getImplicitOffset();
                List<PyParameter> params = PyUtil.getParameters(callable, this.myTypeEvalContext);
                PyNamedParameter pyNamedParameter = allegedFirstParam = params.size() < firstParamOffset ? null : params.get(firstParamOffset - 1).getAsNamed();
                if (allegedFirstParam == null || allegedFirstParam.isKeywordContainer()) {
                    this.registerProblem((PsiElement)deco, PyBundle.message("INSP.func.$0.lacks.first.arg", callable.getName()));
                    continue;
                }
                for (int i = firstParamOffset; i < params.size(); ++i) {
                    PyNamedParameter par;
                    PyParameter parameter = params.get(i);
                    if (parameter instanceof PySingleStarParameter || (par = parameter.getAsNamed()) != null && (par.isKeywordContainer() || par.isPositionalContainer() || par.hasDefaultValue())) continue;
                    String parameterName = par != null ? par.getName() : "(...)";
                    this.registerProblem((PsiElement)deco, PyBundle.message("INSP.parameter.$0.unfilled", parameterName));
                }
            }
        }
    }
}

