/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.RemoveArgumentEqualDefaultQuickFix;
import com.jetbrains.python.psi.CallArgumentsMapping;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyClassType;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyArgumentEqualDefaultInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.argument.equal.default", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyArgumentEqualDefaultInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyArgumentEqualDefaultInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyArgumentEqualDefaultInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyArgumentEqualDefaultInspection", "buildVisitor"));
        }
        return visitor;
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyArgumentEqualDefaultInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            PyArgumentList list = node.getArgumentList();
            if (list == null) {
                return;
            }
            Callable func = node.resolveCalleeFunction(this.getResolveContext());
            if (func != null && Visitor.hasSpecialCasedDefaults(func, (PsiElement)node)) {
                return;
            }
            CallArgumentsMapping result = list.analyzeCall(this.getResolveContext());
            this.checkArguments(result, node.getArguments());
        }

        private static boolean hasSpecialCasedDefaults(Callable callable, PsiElement anchor) {
            String name = callable.getName();
            PyBuiltinCache cache = PyBuiltinCache.getInstance(anchor);
            if ("getattr".equals(name) && cache.isBuiltin((PsiElement)callable)) {
                return true;
            }
            if ("get".equals(name) || "pop".equals(name)) {
                PyFunction method = callable.asMethod();
                PyClassType dictType = cache.getDictType();
                if (method != null && dictType != null && method.getContainingClass() == dictType.getPyClass()) {
                    return true;
                }
            }
            return false;
        }

        private void checkArguments(CallArgumentsMapping result, PyExpression[] arguments) {
            Map<PyExpression, PyNamedParameter> mapping = result.getPlainMappedParams();
            HashSet<PyExpression> problemElements = new HashSet<PyExpression>();
            for (Map.Entry<PyExpression, PyNamedParameter> e : mapping.entrySet()) {
                PyExpression defaultValue = e.getValue().getDefaultValue();
                if (defaultValue == null) continue;
                PyExpression key = e.getKey();
                if (key instanceof PyKeywordArgument && ((PyKeywordArgument)key).getValueExpression() != null) {
                    key = ((PyKeywordArgument)key).getValueExpression();
                }
                if (!this.isEqual(key, defaultValue)) continue;
                problemElements.add(e.getKey());
            }
            boolean canDelete = true;
            for (int i = arguments.length - 1; i != -1; --i) {
                if (problemElements.contains(arguments[i])) {
                    if (canDelete) {
                        this.registerProblem((PsiElement)arguments[i], PyBundle.message("INSP.argument.equals.to.default", new Object[0]), new RemoveArgumentEqualDefaultQuickFix(problemElements));
                        continue;
                    }
                    this.registerProblem((PsiElement)arguments[i], PyBundle.message("INSP.argument.equals.to.default", new Object[0]));
                    continue;
                }
                if (arguments[i] instanceof PyKeywordArgument) continue;
                canDelete = false;
            }
        }

        private boolean isEqual(PyExpression key, PyExpression defaultValue) {
            if (Visitor.isBothInstanceOf(key, defaultValue, PyNumericLiteralExpression.class) || Visitor.isBothInstanceOf(key, defaultValue, PyPrefixExpression.class) || Visitor.isBothInstanceOf(key, defaultValue, PyBinaryExpression.class)) {
                if (key.getText().equals(defaultValue.getText())) {
                    return true;
                }
            } else if (key instanceof PyStringLiteralExpression && defaultValue instanceof PyStringLiteralExpression) {
                if (((PyStringLiteralExpression)key).getStringValue().equals(((PyStringLiteralExpression)defaultValue).getStringValue())) {
                    return true;
                }
            } else {
                PsiReference defRef;
                PsiReference keyRef = key instanceof PyReferenceExpression ? ((PyReferenceExpression)key).getReference(this.getResolveContext()) : key.getReference();
                Object object = defRef = defaultValue instanceof PyReferenceExpression ? ((PyReferenceExpression)defaultValue).getReference(this.getResolveContext()) : defaultValue.getReference();
                if (keyRef != null && defRef != null) {
                    PsiElement keyResolve = keyRef.resolve();
                    PsiElement defResolve = defRef.resolve();
                    if (keyResolve != null && keyResolve.equals(defResolve)) {
                        return true;
                    }
                }
            }
            return false;
        }

        private static boolean isBothInstanceOf(@NotNull PyExpression key, @NotNull PyExpression defaultValue, @NotNull Class clazz) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/inspections/PyArgumentEqualDefaultInspection$Visitor", "isBothInstanceOf"));
            }
            if (defaultValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/jetbrains/python/inspections/PyArgumentEqualDefaultInspection$Visitor", "isBothInstanceOf"));
            }
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/python/inspections/PyArgumentEqualDefaultInspection$Visitor", "isBothInstanceOf"));
            }
            return clazz.isInstance(key) && clazz.isInstance(defaultValue);
        }
    }
}

