/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.highlighting;

import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.python.console.parsing.PyConsoleHighlightingLexer;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.lexer.PythonHighlightingLexer;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySyntaxHighlighterFactory
extends SyntaxHighlighterFactory {
    private final FactoryMap<LanguageLevel, PyHighlighter> myMap = new FactoryMap<LanguageLevel, PyHighlighter>(){

        protected PyHighlighter create(LanguageLevel key) {
            return new PyHighlighter(key);
        }
    };
    private final FactoryMap<LanguageLevel, PyHighlighter> myConsoleMap = new FactoryMap<LanguageLevel, PyHighlighter>(){

        protected PyHighlighter create(LanguageLevel key) {
            return new PyHighlighter(key){

                @Override
                protected PythonHighlightingLexer createHighlightingLexer(LanguageLevel languageLevel) {
                    return new PyConsoleHighlightingLexer(languageLevel);
                }
            };
        }
    };

    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        LanguageLevel level = project != null && virtualFile != null ? PyUtil.getLanguageLevelForVirtualFile(project, virtualFile) : LanguageLevel.getDefault();
        SyntaxHighlighter syntaxHighlighter = (SyntaxHighlighter)this.myMap.get((Object)level);
        if (syntaxHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/highlighting/PySyntaxHighlighterFactory", "getSyntaxHighlighter"));
        }
        return syntaxHighlighter;
    }
}

