/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.hierarchy.treestructures;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Query;
import com.jetbrains.python.hierarchy.PyHierarchyNodeDescriptor;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.search.PyClassInheritorsSearch;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class PySubTypesHierarchyTreeStructure
extends HierarchyTreeStructure {
    protected PySubTypesHierarchyTreeStructure(Project project, HierarchyNodeDescriptor baseDescriptor) {
        super(project, baseDescriptor);
    }

    public PySubTypesHierarchyTreeStructure(@NotNull PyClass cl) {
        if (cl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cl", "com/jetbrains/python/hierarchy/treestructures/PySubTypesHierarchyTreeStructure", "<init>"));
        }
        super(cl.getProject(), new PyHierarchyNodeDescriptor(null, cl, true));
    }

    @Override
    @NotNull
    protected Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/hierarchy/treestructures/PySubTypesHierarchyTreeStructure", "buildChildren"));
        }
        ArrayList<PyHierarchyNodeDescriptor> res = new ArrayList<PyHierarchyNodeDescriptor>();
        PsiElement element = ((PyHierarchyNodeDescriptor)descriptor).getPsiElement();
        if (element instanceof PyClass) {
            PyClass cls = (PyClass)element;
            Query<PyClass> subClasses = PyClassInheritorsSearch.search(cls, false);
            for (PyClass subClass : subClasses) {
                res.add(new PyHierarchyNodeDescriptor(descriptor, subClass, false));
            }
        }
        Object[] objectArray = ArrayUtil.toObjectArray(res);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/hierarchy/treestructures/PySubTypesHierarchyTreeStructure", "buildChildren"));
        }
        return objectArray;
    }
}

