/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.hierarchy.call;

import com.google.common.collect.Lists;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.python.findUsages.PyClassFindUsagesHandler;
import com.jetbrains.python.findUsages.PyFunctionFindUsagesHandler;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStaticCallHierarchyUtil {
    public static Collection<PsiElement> getCallees(@NotNull PyElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/hierarchy/call/PyStaticCallHierarchyUtil", "getCallees"));
        }
        final ArrayList callees = Lists.newArrayList();
        PyRecursiveElementVisitor visitor = new PyRecursiveElementVisitor(){

            @Override
            public void visitPyParameterList(PyParameterList node) {
            }

            @Override
            public void visitPyLambdaExpression(PyLambdaExpression node) {
            }

            @Override
            public void visitPyFunction(PyFunction innerFunction) {
                for (PyParameter parameter : innerFunction.getParameterList().getParameters()) {
                    PyExpression defaultValue = parameter.getDefaultValue();
                    if (defaultValue == null) continue;
                    defaultValue.accept(this);
                }
            }

            @Override
            public void visitPyCallExpression(PyCallExpression callExpression) {
                super.visitPyCallExpression(callExpression);
                Callable calleeFunction = callExpression.resolveCalleeFunction(PyResolveContext.defaultContext());
                if (calleeFunction instanceof PyFunction) {
                    callees.add(calleeFunction);
                }
            }
        };
        visitor.visitElement((PsiElement)element);
        return callees;
    }

    public static Collection<PsiElement> getCallers(@NotNull PyElement pyElement) {
        if (pyElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyElement", "com/jetbrains/python/hierarchy/call/PyStaticCallHierarchyUtil", "getCallers"));
        }
        ArrayList callers = Lists.newArrayList();
        Collection<UsageInfo> usages = PyStaticCallHierarchyUtil.findUsages((PsiElement)pyElement);
        for (UsageInfo usage : usages) {
            PsiElement element = usage.getElement();
            if (element == null) continue;
            element = element.getParent();
            while (element instanceof PyParenthesizedExpression) {
                element = element.getParent();
            }
            if (!(element instanceof PyCallExpression)) continue;
            PsiElement caller = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PyParameterList.class, PyFunction.class});
            if (caller instanceof PyFunction) {
                callers.add(caller);
                continue;
            }
            if (!(caller instanceof PyParameterList)) continue;
            PsiElement innerFunction = PsiTreeUtil.getParentOfType((PsiElement)caller, PyFunction.class);
            PsiElement outerFunction = PsiTreeUtil.getParentOfType((PsiElement)innerFunction, PyFunction.class);
            if (innerFunction == null || outerFunction == null) continue;
            callers.add(outerFunction);
        }
        return callers;
    }

    private static Collection<UsageInfo> findUsages(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/hierarchy/call/PyStaticCallHierarchyUtil", "findUsages"));
        }
        FindUsagesHandler handler = PyStaticCallHierarchyUtil.createFindUsageHandler(element);
        if (handler == null) {
            return Lists.newArrayList();
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        PsiElement[] psiElements = (PsiElement[])ArrayUtil.mergeArrays((Object[])handler.getPrimaryElements(), (Object[])handler.getSecondaryElements());
        FindUsagesOptions options = handler.getFindUsagesOptions(null);
        for (PsiElement psiElement : psiElements) {
            handler.processElementUsages(psiElement, (Processor<UsageInfo>)processor, options);
        }
        return processor.getResults();
    }

    @Nullable
    private static FindUsagesHandler createFindUsageHandler(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/hierarchy/call/PyStaticCallHierarchyUtil", "createFindUsageHandler"));
        }
        if (element instanceof PyFunction) {
            PsiElement next;
            Collection superMethods = PySuperMethodsSearch.search((PyFunction)element, true).findAll();
            if (superMethods.size() > 0 && (next = (PsiElement)superMethods.iterator().next()) instanceof PyFunction && !PyStaticCallHierarchyUtil.isInObject((PyFunction)next)) {
                ArrayList allMethods = Lists.newArrayList();
                allMethods.add(element);
                allMethods.addAll(superMethods);
                return new PyFunctionFindUsagesHandler(element, allMethods);
            }
            return new PyFunctionFindUsagesHandler(element);
        }
        if (element instanceof PyClass) {
            return new PyClassFindUsagesHandler((PyClass)element);
        }
        return null;
    }

    private static boolean isInObject(PyFunction fun) {
        PyClass containingClass = fun.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        return PyUtil.isObjectClass(containingClass);
    }
}

