/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.hierarchy.call;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.hierarchy.PyHierarchyNodeDescriptor;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PyCallHierarchyTreeStructureBase
extends HierarchyTreeStructure {
    private final String myScopeType;

    public PyCallHierarchyTreeStructureBase(Project project, PsiElement element, String currentScopeType) {
        super(project, new PyHierarchyNodeDescriptor(null, element, true));
        this.myScopeType = currentScopeType;
    }

    @NotNull
    protected abstract List<PsiElement> getChildren(@NotNull PyElement var1);

    @Override
    @NotNull
    protected Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/hierarchy/call/PyCallHierarchyTreeStructureBase", "buildChildren"));
        }
        ArrayList<PyHierarchyNodeDescriptor> descriptors = new ArrayList<PyHierarchyNodeDescriptor>();
        if (descriptor instanceof PyHierarchyNodeDescriptor) {
            PyHierarchyNodeDescriptor pyDescriptor = (PyHierarchyNodeDescriptor)descriptor;
            PsiElement element = pyDescriptor.getPsiElement();
            boolean isCallable = element instanceof PyFunction || element instanceof PyClass || element instanceof PyFile;
            HierarchyNodeDescriptor nodeDescriptor = this.getBaseDescriptor();
            if (!(element instanceof PyElement) || !isCallable || nodeDescriptor == null) {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/hierarchy/call/PyCallHierarchyTreeStructureBase", "buildChildren"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            List<PsiElement> children = this.getChildren((PyElement)element);
            HashMap<PsiElement, PyHierarchyNodeDescriptor> callerToDescriptorMap = new HashMap<PsiElement, PyHierarchyNodeDescriptor>();
            PyClass baseClass = element instanceof PyFunction ? ((PyFunction)element).getContainingClass() : null;
            for (PsiElement caller : children) {
                PyHierarchyNodeDescriptor callerDescriptor;
                if (!this.isInScope(baseClass, caller, this.myScopeType) || (callerDescriptor = (PyHierarchyNodeDescriptor)((Object)callerToDescriptorMap.get(caller))) != null) continue;
                callerDescriptor = new PyHierarchyNodeDescriptor(descriptor, caller, false);
                callerToDescriptorMap.put(caller, callerDescriptor);
                descriptors.add(callerDescriptor);
            }
        }
        Object[] objectArray = ArrayUtil.toObjectArray(descriptors);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/hierarchy/call/PyCallHierarchyTreeStructureBase", "buildChildren"));
        }
        return objectArray;
    }

    @Override
    public boolean isAlwaysShowPlus() {
        return true;
    }
}

