/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.hierarchy.call;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.ide.hierarchy.CallHierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.hierarchy.call.PyCallHierarchyBrowser;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCallHierarchyProvider
implements HierarchyProvider {
    @Nullable
    public PsiElement getTarget(@NotNull DataContext dataContext) {
        Editor editor;
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/python/hierarchy/call/PyCallHierarchyProvider", "getTarget"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (element == null && (editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext)) != null) {
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file == null) {
                return null;
            }
            element = TargetElementUtilBase.findTargetElement(editor, 11);
            if (element instanceof PyFunction || element instanceof PyClass || element instanceof PyFile) {
                return element;
            }
            element = file.findElementAt(editor.getCaretModel().getOffset());
        }
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PyFunction.class, PyClass.class, PyFile.class});
    }

    @NotNull
    public HierarchyBrowser createHierarchyBrowser(PsiElement target) {
        PyCallHierarchyBrowser pyCallHierarchyBrowser = new PyCallHierarchyBrowser(target);
        if (pyCallHierarchyBrowser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/hierarchy/call/PyCallHierarchyProvider", "createHierarchyBrowser"));
        }
        return pyCallHierarchyBrowser;
    }

    public void browserActivated(@NotNull HierarchyBrowser hierarchyBrowser) {
        if (hierarchyBrowser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchyBrowser", "com/jetbrains/python/hierarchy/call/PyCallHierarchyProvider", "browserActivated"));
        }
        ((PyCallHierarchyBrowser)hierarchyBrowser).changeView(CallHierarchyBrowserBase.CALLER_TYPE);
    }
}

