/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.hierarchy.call;

import com.intellij.ide.hierarchy.CallHierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.ui.PopupHandler;
import com.jetbrains.python.hierarchy.PyHierarchyNodeDescriptor;
import com.jetbrains.python.hierarchy.PyHierarchyUtils;
import com.jetbrains.python.hierarchy.call.PyCalleeFunctionTreeStructure;
import com.jetbrains.python.hierarchy.call.PyCallerFunctionTreeStructure;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCallHierarchyBrowser
extends CallHierarchyBrowserBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.hierarchy.call.PyCallHierarchyBrowser");
    private static final String GROUP_PY_CALL_HIERARCHY_POPUP = "PyCallHierarchyPopupMenu";

    public PyCallHierarchyBrowser(PsiElement function) {
        super(function.getProject(), function);
    }

    @Override
    @Nullable
    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/hierarchy/call/PyCallHierarchyBrowser", "getElementFromDescriptor"));
        }
        if (descriptor instanceof PyHierarchyNodeDescriptor) {
            PyHierarchyNodeDescriptor pyDescriptor = (PyHierarchyNodeDescriptor)descriptor;
            return pyDescriptor.getPsiElement();
        }
        return null;
    }

    @Override
    protected void createTrees(@NotNull Map<String, JTree> type2TreeMap) {
        if (type2TreeMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2TreeMap", "com/jetbrains/python/hierarchy/call/PyCallHierarchyBrowser", "createTrees"));
        }
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction(GROUP_PY_CALL_HIERARCHY_POPUP);
        JTree callerTree = this.createHierarchyTree(group);
        JTree calleeTree = this.createHierarchyTree(group);
        type2TreeMap.put(CALLER_TYPE, callerTree);
        type2TreeMap.put(CALLEE_TYPE, calleeTree);
    }

    private JTree createHierarchyTree(ActionGroup group) {
        JTree tree = this.createTree(false);
        PopupHandler.installPopupHandler((JComponent)tree, (ActionGroup)group, (String)"CallHierarchyViewPopup", (ActionManager)ActionManager.getInstance());
        return tree;
    }

    @Override
    protected boolean isApplicableElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/hierarchy/call/PyCallHierarchyBrowser", "isApplicableElement"));
        }
        return element instanceof PyFunction || element instanceof PyClass || element instanceof PyFile;
    }

    @Override
    @Nullable
    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String typeName, @NotNull PsiElement psiElement) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/jetbrains/python/hierarchy/call/PyCallHierarchyBrowser", "createHierarchyTreeStructure"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/python/hierarchy/call/PyCallHierarchyBrowser", "createHierarchyTreeStructure"));
        }
        if (CALLER_TYPE.equals(typeName)) {
            return new PyCallerFunctionTreeStructure(this.myProject, psiElement, this.getCurrentScopeType());
        }
        if (CALLEE_TYPE.equals(typeName)) {
            return new PyCalleeFunctionTreeStructure(this.myProject, psiElement, this.getCurrentScopeType());
        }
        LOG.error("unexpected type: " + typeName);
        return null;
    }

    @Override
    @Nullable
    protected Comparator<NodeDescriptor> getComparator() {
        return PyHierarchyUtils.getComparator(this.myProject);
    }
}

