/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.hierarchy;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.TypeHierarchyBrowserBase;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.ui.PopupHandler;
import com.jetbrains.python.hierarchy.PyHierarchyNodeDescriptor;
import com.jetbrains.python.hierarchy.PyHierarchyUtils;
import com.jetbrains.python.hierarchy.treestructures.PySubTypesHierarchyTreeStructure;
import com.jetbrains.python.hierarchy.treestructures.PySuperTypesHierarchyTreeStructure;
import com.jetbrains.python.hierarchy.treestructures.PyTypeHierarchyTreeStructure;
import com.jetbrains.python.psi.PyClass;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypeHierarchyBrowser
extends TypeHierarchyBrowserBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.hierarchy.TypeHierarchyBrowser");

    protected PyTypeHierarchyBrowser(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/hierarchy/PyTypeHierarchyBrowser", "<init>"));
        }
        super(pyClass.getProject(), pyClass);
    }

    @Override
    @Nullable
    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/hierarchy/PyTypeHierarchyBrowser", "getElementFromDescriptor"));
        }
        if (!(descriptor instanceof PyHierarchyNodeDescriptor)) {
            return null;
        }
        return ((PyHierarchyNodeDescriptor)descriptor).getPsiElement();
    }

    @Override
    protected void createTrees(@NotNull Map<String, JTree> trees) {
        if (trees == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trees", "com/jetbrains/python/hierarchy/PyTypeHierarchyBrowser", "createTrees"));
        }
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("PyTypeHierarchyPopupMenu");
        TypeHierarchyBrowserBase.BaseOnThisTypeAction baseOnThisTypeAction = new TypeHierarchyBrowserBase.BaseOnThisTypeAction();
        JTree tree1 = this.createTree(true);
        PopupHandler.installPopupHandler((JComponent)tree1, (ActionGroup)group, (String)"TypeHierarchyViewPopup", (ActionManager)ActionManager.getInstance());
        baseOnThisTypeAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("TypeHierarchy").getShortcutSet(), tree1);
        trees.put(TYPE_HIERARCHY_TYPE, tree1);
        JTree tree2 = this.createTree(true);
        PopupHandler.installPopupHandler((JComponent)tree2, (ActionGroup)group, (String)"TypeHierarchyViewPopup", (ActionManager)ActionManager.getInstance());
        baseOnThisTypeAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("TypeHierarchy").getShortcutSet(), tree2);
        trees.put(SUPERTYPES_HIERARCHY_TYPE, tree2);
        JTree tree3 = this.createTree(true);
        PopupHandler.installPopupHandler((JComponent)tree3, (ActionGroup)group, (String)"TypeHierarchyViewPopup", (ActionManager)ActionManager.getInstance());
        baseOnThisTypeAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("TypeHierarchy").getShortcutSet(), tree3);
        trees.put(SUBTYPES_HIERARCHY_TYPE, tree3);
    }

    @Override
    @Nullable
    protected JPanel createLegendPanel() {
        return null;
    }

    @Override
    protected boolean isApplicableElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/hierarchy/PyTypeHierarchyBrowser", "isApplicableElement"));
        }
        return element instanceof PyClass;
    }

    @Override
    @Nullable
    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String typeName, @NotNull PsiElement psiElement) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/jetbrains/python/hierarchy/PyTypeHierarchyBrowser", "createHierarchyTreeStructure"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/python/hierarchy/PyTypeHierarchyBrowser", "createHierarchyTreeStructure"));
        }
        if (SUPERTYPES_HIERARCHY_TYPE.equals(typeName)) {
            return new PySuperTypesHierarchyTreeStructure((PyClass)psiElement);
        }
        if (SUBTYPES_HIERARCHY_TYPE.equals(typeName)) {
            return new PySubTypesHierarchyTreeStructure((PyClass)psiElement);
        }
        if (TYPE_HIERARCHY_TYPE.equals(typeName)) {
            return new PyTypeHierarchyTreeStructure((PyClass)psiElement);
        }
        LOG.error("unexpected type: " + typeName);
        return null;
    }

    @Override
    @Nullable
    protected Comparator<NodeDescriptor> getComparator() {
        return PyHierarchyUtils.getComparator(this.myProject);
    }

    @Override
    protected boolean isInterface(PsiElement psiElement) {
        return false;
    }

    @Override
    protected boolean canBeDeleted(PsiElement psiElement) {
        return psiElement instanceof PyClass;
    }

    @Override
    @NotNull
    protected String getQualifiedName(PsiElement psiElement) {
        String name;
        if (psiElement instanceof PyClass && (name = ((PyClass)psiElement).getName()) != null) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/hierarchy/PyTypeHierarchyBrowser", "getQualifiedName"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/hierarchy/PyTypeHierarchyBrowser", "getQualifiedName"));
        }
        return "";
    }
}

