/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.hierarchy;

import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class PyHierarchyUtils {
    private static final Comparator<NodeDescriptor> NODE_DESCRIPTOR_COMPARATOR = new Comparator<NodeDescriptor>(){

        @Override
        public int compare(NodeDescriptor first, NodeDescriptor second) {
            return first.getIndex() - second.getIndex();
        }
    };

    private PyHierarchyUtils() {
    }

    @NotNull
    public static Comparator<NodeDescriptor> getComparator(Project project) {
        if (HierarchyBrowserManager.getInstance((Project)project).getState().SORT_ALPHABETICALLY) {
            AlphaComparator alphaComparator = AlphaComparator.INSTANCE;
            if (alphaComparator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/hierarchy/PyHierarchyUtils", "getComparator"));
            }
            return alphaComparator;
        }
        Comparator<NodeDescriptor> comparator = NODE_DESCRIPTOR_COMPARATOR;
        if (comparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/hierarchy/PyHierarchyUtils", "getComparator"));
        }
        return comparator;
    }
}

