/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.CustomFormattingModelBuilder;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilderEx;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.formatting.Indent;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.formatter.PyBlock;
import com.jetbrains.python.formatter.PyBlockContext;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonFormattingModelBuilder
implements FormattingModelBuilderEx,
CustomFormattingModelBuilder {
    private static final boolean DUMP_FORMATTING_AST = false;
    private static final TokenSet SINGLE_SPACE_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.IN_KEYWORD, PyTokenTypes.AND_KEYWORD, PyTokenTypes.OR_KEYWORD, PyTokenTypes.IS_KEYWORD, PyTokenTypes.IF_KEYWORD, PyTokenTypes.ELIF_KEYWORD, PyTokenTypes.FOR_KEYWORD, PyTokenTypes.RETURN_KEYWORD, PyTokenTypes.RAISE_KEYWORD, PyTokenTypes.ASSERT_KEYWORD, PyTokenTypes.CLASS_KEYWORD, PyTokenTypes.DEF_KEYWORD, PyTokenTypes.DEL_KEYWORD, PyTokenTypes.EXEC_KEYWORD, PyTokenTypes.GLOBAL_KEYWORD, PyTokenTypes.IMPORT_KEYWORD, PyTokenTypes.LAMBDA_KEYWORD, PyTokenTypes.NOT_KEYWORD, PyTokenTypes.WHILE_KEYWORD, PyTokenTypes.YIELD_KEYWORD});

    @Override
    @NotNull
    public FormattingModel createModel(@NotNull PsiElement element, @NotNull CodeStyleSettings settings, @NotNull FormattingMode mode) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/formatter/PythonFormattingModelBuilder", "createModel"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/python/formatter/PythonFormattingModelBuilder", "createModel"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/jetbrains/python/formatter/PythonFormattingModelBuilder", "createModel"));
        }
        FileASTNode fileNode = element.getContainingFile().getNode();
        PyBlockContext context = new PyBlockContext(settings, this.createSpacingBuilder(settings), mode);
        PyBlock block = new PyBlock(null, (ASTNode)fileNode, null, Indent.getNoneIndent(), null, context);
        FormattingModel formattingModel = FormattingModelProvider.createFormattingModelForPsiFile((PsiFile)element.getContainingFile(), (Block)block, (CodeStyleSettings)settings);
        if (formattingModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/formatter/PythonFormattingModelBuilder", "createModel"));
        }
        return formattingModel;
    }

    @Override
    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsToUse(@NotNull PsiFile file, @NotNull FormatTextRanges ranges, @NotNull CodeStyleSettings settings) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/formatter/PythonFormattingModelBuilder", "getIndentOptionsToUse"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/jetbrains/python/formatter/PythonFormattingModelBuilder", "getIndentOptionsToUse"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/python/formatter/PythonFormattingModelBuilder", "getIndentOptionsToUse"));
        }
        return null;
    }

    @NotNull
    public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
        FormattingModel formattingModel = this.createModel(element, settings, FormattingMode.REFORMAT);
        if (formattingModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/formatter/PythonFormattingModelBuilder", "createModel"));
        }
        return formattingModel;
    }

    protected SpacingBuilder createSpacingBuilder(CodeStyleSettings settings) {
        IFileElementType file = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)PythonLanguage.getInstance())).getFileNodeType();
        PyCodeStyleSettings pySettings = (PyCodeStyleSettings)settings.getCustomSettings(PyCodeStyleSettings.class);
        TokenSet STATEMENT_OR_DECLARATION = TokenSet.orSet((TokenSet[])new TokenSet[]{PythonDialectsTokenSetProvider.INSTANCE.getStatementTokens(), PyElementTypes.CLASS_OR_FUNCTION});
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings((Language)PythonLanguage.getInstance());
        return new SpacingBuilder(commonSettings).betweenInside(STATEMENT_OR_DECLARATION, PyElementTypes.CLASS_OR_FUNCTION, (IElementType)file).blankLines(pySettings.BLANK_LINES_AROUND_TOP_LEVEL_CLASSES_FUNCTIONS).betweenInside(PyElementTypes.CLASS_OR_FUNCTION, STATEMENT_OR_DECLARATION, (IElementType)file).blankLines(pySettings.BLANK_LINES_AROUND_TOP_LEVEL_CLASSES_FUNCTIONS).between(PyElementTypes.IMPORT_STATEMENTS, TokenSet.andNot((TokenSet)STATEMENT_OR_DECLARATION, (TokenSet)PyElementTypes.IMPORT_STATEMENTS)).blankLines(commonSettings.BLANK_LINES_AFTER_IMPORTS).betweenInside(PyElementTypes.CLASS_OR_FUNCTION, PyElementTypes.CLASS_OR_FUNCTION, (IElementType)file).blankLines(pySettings.BLANK_LINES_AROUND_TOP_LEVEL_CLASSES_FUNCTIONS).between(PyElementTypes.CLASS_DECLARATION, STATEMENT_OR_DECLARATION).blankLines(commonSettings.BLANK_LINES_AROUND_CLASS).between(STATEMENT_OR_DECLARATION, PyElementTypes.CLASS_DECLARATION).blankLines(commonSettings.BLANK_LINES_AROUND_CLASS).between(PyElementTypes.FUNCTION_DECLARATION, STATEMENT_OR_DECLARATION).blankLines(commonSettings.BLANK_LINES_AROUND_METHOD).between(STATEMENT_OR_DECLARATION, PyElementTypes.FUNCTION_DECLARATION).blankLines(commonSettings.BLANK_LINES_AROUND_METHOD).after(PyElementTypes.FUNCTION_DECLARATION).blankLines(commonSettings.BLANK_LINES_AROUND_METHOD).after(PyElementTypes.CLASS_DECLARATION).blankLines(commonSettings.BLANK_LINES_AROUND_CLASS).between(STATEMENT_OR_DECLARATION, STATEMENT_OR_DECLARATION).spacing(0, Integer.MAX_VALUE, 1, false, 1).between((IElementType)PyTokenTypes.COLON, (IElementType)PyElementTypes.STATEMENT_LIST).spacing(1, Integer.MAX_VALUE, 0, true, 0).afterInside((IElementType)PyTokenTypes.COLON, TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.KEY_VALUE_EXPRESSION, PyElementTypes.LAMBDA_EXPRESSION})).spaceIf(pySettings.SPACE_AFTER_PY_COLON).afterInside((IElementType)PyTokenTypes.GT, PyElementTypes.ANNOTATION).spaces(1).betweenInside((IElementType)PyTokenTypes.MINUS, (IElementType)PyTokenTypes.GT, PyElementTypes.ANNOTATION).none().beforeInside(PyElementTypes.ANNOTATION, PyElementTypes.FUNCTION_DECLARATION).spaces(1).beforeInside(PyElementTypes.ANNOTATION, PyElementTypes.NAMED_PARAMETER).none().between(PythonFormattingModelBuilder.allButLambda(), PyElementTypes.PARAMETER_LIST).spaceIf(commonSettings.SPACE_BEFORE_METHOD_PARENTHESES).before((IElementType)PyTokenTypes.COLON).spaceIf(pySettings.SPACE_BEFORE_PY_COLON).after((IElementType)PyTokenTypes.COMMA).spaceIf(commonSettings.SPACE_AFTER_COMMA).before((IElementType)PyTokenTypes.COMMA).spaceIf(commonSettings.SPACE_BEFORE_COMMA).between((IElementType)PyTokenTypes.FROM_KEYWORD, (IElementType)PyTokenTypes.DOT).spaces(1).between((IElementType)PyTokenTypes.DOT, (IElementType)PyTokenTypes.IMPORT_KEYWORD).spaces(1).around((IElementType)PyTokenTypes.DOT).spaces(0).before((IElementType)PyTokenTypes.SEMICOLON).spaceIf(commonSettings.SPACE_BEFORE_SEMICOLON).withinPairInside((IElementType)PyTokenTypes.LPAR, (IElementType)PyTokenTypes.RPAR, (IElementType)PyElementTypes.ARGUMENT_LIST).spaceIf(commonSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES).withinPairInside((IElementType)PyTokenTypes.LPAR, (IElementType)PyTokenTypes.RPAR, PyElementTypes.PARAMETER_LIST).spaceIf(commonSettings.SPACE_WITHIN_METHOD_PARENTHESES).withinPairInside((IElementType)PyTokenTypes.LPAR, (IElementType)PyTokenTypes.RPAR, PyElementTypes.FROM_IMPORT_STATEMENT).spaces(0).withinPairInside((IElementType)PyTokenTypes.LPAR, (IElementType)PyTokenTypes.RPAR, (IElementType)PyElementTypes.GENERATOR_EXPRESSION).spaces(0).before((IElementType)PyTokenTypes.LBRACKET).spaceIf(pySettings.SPACE_BEFORE_LBRACKET).withinPair((IElementType)PyTokenTypes.LBRACE, (IElementType)PyTokenTypes.RBRACE).spaceIf(pySettings.SPACE_WITHIN_BRACES).withinPair((IElementType)PyTokenTypes.LBRACKET, (IElementType)PyTokenTypes.RBRACKET).spaceIf(commonSettings.SPACE_WITHIN_BRACKETS).before((IElementType)PyElementTypes.ARGUMENT_LIST).spaceIf(commonSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES).around(PyElementTypes.DECORATOR_CALL).spacing(1, Integer.MAX_VALUE, 0, true, 0).after(PyElementTypes.DECORATOR_LIST).spacing(1, Integer.MAX_VALUE, 0, true, 0).aroundInside((IElementType)PyTokenTypes.EQ, (IElementType)PyElementTypes.ASSIGNMENT_STATEMENT).spaceIf(commonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS).aroundInside((IElementType)PyTokenTypes.EQ, PyElementTypes.NAMED_PARAMETER).spaceIf(pySettings.SPACE_AROUND_EQ_IN_NAMED_PARAMETER).aroundInside((IElementType)PyTokenTypes.EQ, (IElementType)PyElementTypes.KEYWORD_ARGUMENT_EXPRESSION).spaceIf(pySettings.SPACE_AROUND_EQ_IN_KEYWORD_ARGUMENT).around(PyTokenTypes.AUG_ASSIGN_OPERATIONS).spaceIf(commonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS).aroundInside(PyTokenTypes.ADDITIVE_OPERATIONS, (IElementType)PyElementTypes.BINARY_EXPRESSION).spaceIf(commonSettings.SPACE_AROUND_ADDITIVE_OPERATORS).aroundInside(PyTokenTypes.MULTIPLICATIVE_OR_EXP, PyElementTypes.STAR_PARAMETERS).none().around(PyTokenTypes.MULTIPLICATIVE_OR_EXP).spaceIf(commonSettings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS).around(PyTokenTypes.SHIFT_OPERATIONS).spaceIf(commonSettings.SPACE_AROUND_SHIFT_OPERATORS).around(PyTokenTypes.BITWISE_OPERATIONS).spaceIf(commonSettings.SPACE_AROUND_BITWISE_OPERATORS).around(PyTokenTypes.EQUALITY_OPERATIONS).spaceIf(commonSettings.SPACE_AROUND_EQUALITY_OPERATORS).around(PyTokenTypes.RELATIONAL_OPERATIONS).spaceIf(commonSettings.SPACE_AROUND_RELATIONAL_OPERATORS).around(SINGLE_SPACE_KEYWORDS).spaces(1);
    }

    private static TokenSet allButLambda() {
        final PythonLanguage pythonLanguage = PythonLanguage.getInstance();
        return TokenSet.create((IElementType[])IElementType.enumerate((IElementType.Predicate)new IElementType.Predicate(){

            public boolean matches(IElementType type) {
                return type != PyTokenTypes.LAMBDA_KEYWORD && type.getLanguage().isKindOf((Language)pythonLanguage);
            }
        }));
    }

    public TextRange getRangeAffectingIndent(PsiFile file, int offset, ASTNode elementAtOffset) {
        return null;
    }

    private static void printAST(ASTNode node, int indent) {
        while (node != null) {
            for (int i = 0; i < indent; ++i) {
                System.out.print(" ");
            }
            System.out.println(node.toString() + " " + node.getTextRange().toString());
            PythonFormattingModelBuilder.printAST(node.getFirstChildNode(), indent + 2);
            node = node.getTreeNext();
        }
    }

    public boolean isEngagedToFormat(PsiElement context) {
        PsiFile file = context.getContainingFile();
        return file != null && file.getLanguage() == PythonLanguage.getInstance();
    }
}

