/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.StaticSymbolWhiteSpaceDefinitionStrategy;
import com.jetbrains.python.editor.PythonEnterHandler;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntProcedure;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class PyWhiteSpaceFormattingStrategy
extends StaticSymbolWhiteSpaceDefinitionStrategy {
    public PyWhiteSpaceFormattingStrategy() {
        super('\\');
    }

    @Override
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, @NotNull PsiElement startElement, int startOffset, int endOffset, CodeStyleSettings codeStyleSettings) {
        if (whiteSpaceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whiteSpaceText", "com/jetbrains/python/formatter/PyWhiteSpaceFormattingStrategy", "adjustWhiteSpaceIfNecessary"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/jetbrains/python/formatter/PyWhiteSpaceFormattingStrategy", "adjustWhiteSpaceIfNecessary"));
        }
        CharSequence whiteSpace = super.adjustWhiteSpaceIfNecessary(whiteSpaceText, startElement, startOffset, endOffset, codeStyleSettings);
        if (whiteSpace.length() > 0 && whiteSpace.charAt(0) == '\n' && !StringUtil.contains((CharSequence)whiteSpace, (int)0, (int)whiteSpace.length(), (char)'\\') && PythonEnterHandler.needInsertBackslash(startElement.getContainingFile(), startOffset, false)) {
            return PyWhiteSpaceFormattingStrategy.addBackslashPrefix(whiteSpace, codeStyleSettings);
        }
        return whiteSpace;
    }

    private static String addBackslashPrefix(CharSequence whiteSpace, CodeStyleSettings settings) {
        PyCodeStyleSettings pySettings = (PyCodeStyleSettings)settings.getCustomSettings(PyCodeStyleSettings.class);
        return (pySettings.SPACE_BEFORE_BACKSLASH ? " \\" : "\\") + ((Object)whiteSpace).toString();
    }

    @Override
    @NotNull
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, @NotNull CharSequence text, int startOffset, int endOffset, CodeStyleSettings codeStyleSettings, ASTNode nodeAfter) {
        if (whiteSpaceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whiteSpaceText", "com/jetbrains/python/formatter/PyWhiteSpaceFormattingStrategy", "adjustWhiteSpaceIfNecessary"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/formatter/PyWhiteSpaceFormattingStrategy", "adjustWhiteSpaceIfNecessary"));
        }
        TIntIntHashMap initialBackSlashes = PyWhiteSpaceFormattingStrategy.countBackSlashes(text, startOffset, endOffset);
        if (initialBackSlashes.isEmpty()) {
            if (nodeAfter != null && whiteSpaceText.length() > 0 && whiteSpaceText.charAt(0) == '\n' && PythonEnterHandler.needInsertBackslash(nodeAfter, false)) {
                String string = PyWhiteSpaceFormattingStrategy.addBackslashPrefix(whiteSpaceText, codeStyleSettings);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/formatter/PyWhiteSpaceFormattingStrategy", "adjustWhiteSpaceIfNecessary"));
                }
                return string;
            }
            CharSequence charSequence = whiteSpaceText;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/formatter/PyWhiteSpaceFormattingStrategy", "adjustWhiteSpaceIfNecessary"));
            }
            return charSequence;
        }
        final TIntIntHashMap newBackSlashes = PyWhiteSpaceFormattingStrategy.countBackSlashes(whiteSpaceText, 0, whiteSpaceText.length());
        final AtomicBoolean continueProcessing = new AtomicBoolean();
        initialBackSlashes.forEachKey(new TIntProcedure(){

            public boolean execute(int key) {
                if (!newBackSlashes.containsKey(key)) {
                    continueProcessing.set(true);
                    return false;
                }
                return true;
            }
        });
        if (!continueProcessing.get()) {
            CharSequence charSequence = whiteSpaceText;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/formatter/PyWhiteSpaceFormattingStrategy", "adjustWhiteSpaceIfNecessary"));
            }
            return charSequence;
        }
        PyCodeStyleSettings settings = (PyCodeStyleSettings)codeStyleSettings.getCustomSettings(PyCodeStyleSettings.class);
        StringBuilder result = new StringBuilder();
        int line = 0;
        for (int i = 0; i < whiteSpaceText.length(); ++i) {
            char c = whiteSpaceText.charAt(i);
            if (c != '\n') {
                result.append(c);
                continue;
            }
            if (!newBackSlashes.contains(line++)) {
                if ((i == 0 || i > 0 && whiteSpaceText.charAt(i - 1) != ' ') && settings.SPACE_BEFORE_BACKSLASH) {
                    result.append(' ');
                }
                result.append('\\');
            }
            result.append(c);
        }
        StringBuilder stringBuilder = result;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/formatter/PyWhiteSpaceFormattingStrategy", "adjustWhiteSpaceIfNecessary"));
        }
        return stringBuilder;
    }

    static TIntIntHashMap countBackSlashes(CharSequence text, int start, int end) {
        TIntIntHashMap result = new TIntIntHashMap();
        int line = 0;
        if (end > text.length()) {
            end = text.length();
        }
        block4: for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\n': {
                    ++line;
                    continue block4;
                }
                case '\\': {
                    result.put(line, 1);
                }
            }
        }
        return result;
    }
}

