/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PyPreFormatProcessor
implements PreFormatProcessor {
    @Override
    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        PsiFile file;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/formatter/PyPreFormatProcessor", "process"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/python/formatter/PyPreFormatProcessor", "process"));
        }
        PsiElement psiElement = element.getPsi();
        if (psiElement == null) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/formatter/PyPreFormatProcessor", "process"));
            }
            return textRange;
        }
        if (!psiElement.getLanguage().is((Language)PythonLanguage.getInstance())) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/formatter/PyPreFormatProcessor", "process"));
            }
            return textRange;
        }
        PsiFile psiFile = file = psiElement.isValid() ? psiElement.getContainingFile() : null;
        if (file == null) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/formatter/PyPreFormatProcessor", "process"));
            }
            return textRange;
        }
        Project project = psiElement.getProject();
        TextRange textRange = new PyCommentFormatter(project).process(psiElement, range);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/formatter/PyPreFormatProcessor", "process"));
        }
        return textRange;
    }

    public static class PyCommentFormatter
    extends PyRecursiveElementVisitor {
        private final Project myProject;
        private final CodeStyleSettings mySettings;
        private final PyCodeStyleSettings myPyCodeStyleSettings;
        private TextRange myRange;
        private int myDelta = 0;

        public PyCommentFormatter(Project project) {
            this.myProject = project;
            this.mySettings = CodeStyleSettingsManager.getSettings((Project)project);
            this.myPyCodeStyleSettings = (PyCodeStyleSettings)this.mySettings.getCustomSettings(PyCodeStyleSettings.class);
        }

        public TextRange process(PsiElement element, TextRange range) {
            if (!this.myPyCodeStyleSettings.SPACE_AFTER_NUMBER_SIGN) {
                return range;
            }
            this.myRange = range;
            element.accept((PsiElementVisitor)this);
            return TextRange.create((int)range.getStartOffset(), (int)(range.getEndOffset() + this.myDelta));
        }

        public void visitComment(PsiComment element) {
            if (!this.myRange.contains(element.getTextRange())) {
                return;
            }
            String text = element.getText();
            int commentStart = text.indexOf(35);
            if (commentStart != -1 && commentStart + 1 < text.length()) {
                char charAfterDash = text.charAt(commentStart + 1);
                if (charAfterDash == '!' && element.getTextRange().getStartOffset() == 0) {
                    return;
                }
                if (charAfterDash == '#' || charAfterDash == ':') {
                    return;
                }
                String commentText = StringUtil.trimLeading((String)text.substring(commentStart + 1));
                String newText = "# " + commentText;
                if (!newText.equals(text)) {
                    this.myDelta += newText.length() - text.length();
                    element.replace((PsiElement)PyElementGenerator.getInstance(this.myProject).createFromText(LanguageLevel.getDefault(), PsiComment.class, newText));
                }
            }
        }
    }
}

