/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.formatter;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.GenericLineWrapPositionStrategy;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.python.psi.StringLiteralExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyLineWrapPositionStrategy
extends GenericLineWrapPositionStrategy {
    public PyLineWrapPositionStrategy() {
        this.addRule(new GenericLineWrapPositionStrategy.Rule(',', GenericLineWrapPositionStrategy.WrapCondition.AFTER, 11.0));
        this.addRule(new GenericLineWrapPositionStrategy.Rule(' '));
        this.addRule(new GenericLineWrapPositionStrategy.Rule('\t'));
        this.addRule(new GenericLineWrapPositionStrategy.Rule('(', GenericLineWrapPositionStrategy.WrapCondition.AFTER));
        this.addRule(new GenericLineWrapPositionStrategy.Rule('[', GenericLineWrapPositionStrategy.WrapCondition.AFTER));
        this.addRule(new GenericLineWrapPositionStrategy.Rule('{', GenericLineWrapPositionStrategy.WrapCondition.AFTER));
    }

    protected boolean canUseOffset(@NotNull Document document, int offset, boolean virtual) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/python/formatter/PyLineWrapPositionStrategy", "canUseOffset"));
        }
        if (virtual) {
            return true;
        }
        CharSequence text = document.getCharsSequence();
        char c = text.charAt(offset);
        if (!StringUtil.isWhiteSpace((char)c)) {
            return true;
        }
        int i = CharArrayUtil.shiftBackward((CharSequence)text, (int)offset, (String)" \t");
        if (i < 2) {
            return true;
        }
        return text.charAt(i - 2) != 'd' || text.charAt(i - 1) != 'e' || text.charAt(i) != 'f';
    }

    public int calculateWrapPosition(@NotNull Document document, @Nullable Project project, int startOffset, int endOffset, int maxPreferredOffset, boolean allowToBeyondMaxPreferredOffset, boolean virtual) {
        PsiElement element;
        StringLiteralExpression string;
        PsiFile psiFile;
        char charBefore;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/python/formatter/PyLineWrapPositionStrategy", "calculateWrapPosition"));
        }
        int wrapPosition = super.calculateWrapPosition(document, project, startOffset, endOffset, maxPreferredOffset, allowToBeyondMaxPreferredOffset, virtual);
        if (wrapPosition < 0) {
            return wrapPosition;
        }
        CharSequence text = document.getImmutableCharSequence();
        if (wrapPosition > 0 && ((charBefore = text.charAt(wrapPosition - 1)) == '\'' || charBefore == '\"')) {
            return wrapPosition + 1;
        }
        if (wrapPosition >= text.length()) {
            return wrapPosition;
        }
        char c = text.charAt(wrapPosition);
        if (!StringUtil.isWhiteSpace((char)c) || project == null) {
            return wrapPosition;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        if (documentManager != null && (psiFile = documentManager.getPsiFile(document)) != null && (string = (StringLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)(element = psiFile.findElementAt(wrapPosition)), StringLiteralExpression.class)) != null) {
            return wrapPosition + 1;
        }
        return wrapPosition;
    }
}

