/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.formatter;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class PyLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    private static String SPACING_SETTINGS_PREVIEW = "def settings_preview(argument, key=value):\n    dict = {1:'a', 2:'b', 3:'c'}\n    x = dict[1]\n    expr = (1+2)*3 << 4 & 16\n    if expr == 0 or abs(expr) < 0: print('weird'); return\n    settings_preview(key=1)\n\nfoo =\\\n    bar";
    private static String BLANK_LINES_SETTINGS_PREVIEW = "import os\nclass C(object):\n    x = 1\n    def foo(self):\n        pass";
    private static String WRAP_SETTINGS_PREVIEW = "from foo import (bar,\n    baz)\n\nlong_expression = component_one + component_two + component_three + component_four + component_five + component_six\n\ndef xyzzy(long_parameter_1,\nlong_parameter_2):\n    pass\n\nxyzzy('long_string_constant1',\n    'long_string_constant2')\nattrs = [e.attr for e in\n    items]\n\nif True: pass\n\ntry: pass\nfinally: pass\n";
    private static String INDENT_SETTINGS_PREVIEW = "def foo():\n    print 'bar'\n\ndef long_function_name(\n        var_one, var_two, var_three,\n        var_four):\n    print(var_one)";

    @NotNull
    public Language getLanguage() {
        PythonLanguage pythonLanguage = PythonLanguage.getInstance();
        if (pythonLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/formatter/PyLanguageCodeStyleSettingsProvider", "getLanguage"));
        }
        return pythonLanguage;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsType", "com/jetbrains/python/formatter/PyLanguageCodeStyleSettingsProvider", "getCodeSample"));
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            return SPACING_SETTINGS_PREVIEW;
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            return BLANK_LINES_SETTINGS_PREVIEW;
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            return WRAP_SETTINGS_PREVIEW;
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS) {
            return INDENT_SETTINGS_PREVIEW;
        }
        return "";
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/python/formatter/PyLanguageCodeStyleSettingsProvider", "customizeSettings"));
        }
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsType", "com/jetbrains/python/formatter/PyLanguageCodeStyleSettingsProvider", "customizeSettings"));
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showStandardOptions(new String[]{"SPACE_BEFORE_METHOD_CALL_PARENTHESES", "SPACE_BEFORE_METHOD_PARENTHESES", "SPACE_AROUND_ASSIGNMENT_OPERATORS", "SPACE_AROUND_EQUALITY_OPERATORS", "SPACE_AROUND_RELATIONAL_OPERATORS", "SPACE_AROUND_BITWISE_OPERATORS", "SPACE_AROUND_ADDITIVE_OPERATORS", "SPACE_AROUND_MULTIPLICATIVE_OPERATORS", "SPACE_AROUND_SHIFT_OPERATORS", "SPACE_WITHIN_METHOD_CALL_PARENTHESES", "SPACE_WITHIN_METHOD_PARENTHESES", "SPACE_WITHIN_BRACKETS", "SPACE_AFTER_COMMA", "SPACE_BEFORE_COMMA", "SPACE_BEFORE_SEMICOLON"});
            consumer.showCustomOption(PyCodeStyleSettings.class, "SPACE_BEFORE_LBRACKET", "Left bracket", CodeStyleSettingsCustomizable.SPACES_BEFORE_PARENTHESES, new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "SPACE_AROUND_EQ_IN_NAMED_PARAMETER", "Around = in named parameter", CodeStyleSettingsCustomizable.SPACES_AROUND_OPERATORS, new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "SPACE_AROUND_EQ_IN_KEYWORD_ARGUMENT", "Around = in keyword argument", CodeStyleSettingsCustomizable.SPACES_AROUND_OPERATORS, new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "SPACE_WITHIN_BRACES", "Braces", CodeStyleSettingsCustomizable.SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "SPACE_BEFORE_PY_COLON", ApplicationBundle.message((String)"checkbox.spaces.before.colon", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "SPACE_AFTER_PY_COLON", ApplicationBundle.message((String)"checkbox.spaces.after.colon", (Object[])new Object[0]), CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "SPACE_BEFORE_BACKSLASH", "Before '\\'", CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "SPACE_BEFORE_NUMBER_SIGN", "Before '#'", CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "SPACE_AFTER_NUMBER_SIGN", "After '#'", CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"BLANK_LINES_AROUND_CLASS", "BLANK_LINES_AROUND_METHOD", "BLANK_LINES_AFTER_IMPORTS", "KEEP_BLANK_LINES_IN_DECLARATIONS", "KEEP_BLANK_LINES_IN_CODE"});
            consumer.showCustomOption(PyCodeStyleSettings.class, "BLANK_LINES_AROUND_TOP_LEVEL_CLASSES_FUNCTIONS", "Around top-level classes and functions:", CodeStyleSettingsCustomizable.BLANK_LINES, new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"RIGHT_MARGIN", "KEEP_LINE_BREAKS", "WRAP_LONG_LINES", "ALIGN_MULTILINE_PARAMETERS", "ALIGN_MULTILINE_PARAMETERS_IN_CALLS"});
            consumer.showCustomOption(PyCodeStyleSettings.class, "NEW_LINE_AFTER_COLON", "Single-clause statements", "Force new line after colon", new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "NEW_LINE_AFTER_COLON_MULTI_CLAUSE", "Multi-clause statements", "Force new line after colon", new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "ALIGN_COLLECTIONS_AND_COMPREHENSIONS", "Align when multiline", "Collections and Comprehensions", new Object[0]);
            consumer.showCustomOption(PyCodeStyleSettings.class, "ALIGN_MULTILINE_IMPORTS", "Align when multiline", "Import Statements", new Object[0]);
        }
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor();
    }

    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings defaultSettings = new CommonCodeStyleSettings((Language)PythonLanguage.getInstance());
        CommonCodeStyleSettings.IndentOptions indentOptions = defaultSettings.initIndentOptions();
        indentOptions.INDENT_SIZE = 4;
        defaultSettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS = true;
        return defaultSettings;
    }

    public DisplayPriority getDisplayPriority() {
        return PlatformUtils.isPyCharm() ? DisplayPriority.KEY_LANGUAGE_SETTINGS : DisplayPriority.LANGUAGE_SETTINGS;
    }

    public boolean isIndentBasedLanguageSemantics() {
        return true;
    }
}

