/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.formatter;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.openapi.options.Configurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.formatter.PyCodeStyleMainPanel;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class PyCodeStyleSettingsProvider
extends CodeStyleSettingsProvider {
    public CustomCodeStyleSettings createCustomSettings(CodeStyleSettings settings) {
        return new PyCodeStyleSettings(settings);
    }

    @NotNull
    public Configurable createSettingsPage(CodeStyleSettings settings, CodeStyleSettings originalSettings) {
        CodeStyleAbstractConfigurable codeStyleAbstractConfigurable = new CodeStyleAbstractConfigurable(settings, originalSettings, "Python"){

            @Override
            protected CodeStyleAbstractPanel createPanel(CodeStyleSettings settings) {
                return new PyCodeStyleMainPanel(this.getCurrentSettings(), settings);
            }

            public String getHelpTopic() {
                return "reference.settingsdialog.codestyle.python";
            }
        };
        if (codeStyleAbstractConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/formatter/PyCodeStyleSettingsProvider", "createSettingsPage"));
        }
        return codeStyleAbstractConfigurable;
    }

    public String getConfigurableDisplayName() {
        return "Python";
    }

    public DisplayPriority getPriority() {
        return PlatformUtils.isPyCharm() ? DisplayPriority.KEY_LANGUAGE_SETTINGS : DisplayPriority.LANGUAGE_SETTINGS;
    }
}

