/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.formatter.PyBlockContext;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElsePart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFileElementType;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PySliceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStatementPart;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWhileStatement;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyBlock
implements ASTBlock {
    private final PyBlock myParent;
    private final Alignment _alignment;
    private final Indent _indent;
    private final ASTNode _node;
    private final Wrap _wrap;
    private final PyBlockContext myContext;
    private List<PyBlock> _subBlocks = null;
    private Alignment myChildAlignment;
    private static final boolean DUMP_FORMATTING_BLOCKS = false;
    public static final Key<Boolean> IMPORT_GROUP_BEGIN = Key.create((String)"com.jetbrains.python.formatter.importGroupBegin");
    private static final TokenSet ourListElementTypes = TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.LIST_LITERAL_EXPRESSION, PyElementTypes.LIST_COMP_EXPRESSION, PyElementTypes.DICT_COMP_EXPRESSION, PyElementTypes.SET_COMP_EXPRESSION, PyElementTypes.DICT_LITERAL_EXPRESSION, PyElementTypes.SET_LITERAL_EXPRESSION, PyElementTypes.ARGUMENT_LIST, PyElementTypes.PARAMETER_LIST, PyElementTypes.TUPLE_EXPRESSION, PyElementTypes.PARENTHESIZED_EXPRESSION, PyElementTypes.SLICE_EXPRESSION, PyElementTypes.SUBSCRIPTION_EXPRESSION, PyElementTypes.GENERATOR_EXPRESSION});
    private static final TokenSet ourBrackets = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.LPAR, PyTokenTypes.RPAR, PyTokenTypes.LBRACE, PyTokenTypes.RBRACE, PyTokenTypes.LBRACKET, PyTokenTypes.RBRACKET});

    public PyBlock(PyBlock parent, ASTNode node, Alignment alignment, Indent indent, Wrap wrap, PyBlockContext context) {
        this.myParent = parent;
        this._alignment = alignment;
        this._indent = indent;
        this._node = node;
        this._wrap = wrap;
        this.myContext = context;
    }

    @NotNull
    public ASTNode getNode() {
        ASTNode aSTNode = this._node;
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/formatter/PyBlock", "getNode"));
        }
        return aSTNode;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this._node.getTextRange();
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/formatter/PyBlock", "getTextRange"));
        }
        return textRange;
    }

    private Alignment getAlignmentForChildren() {
        if (this.myChildAlignment == null) {
            this.myChildAlignment = Alignment.createAlignment();
        }
        return this.myChildAlignment;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (this._subBlocks == null) {
            this._subBlocks = this.buildSubBlocks();
        }
        ArrayList<PyBlock> arrayList = new ArrayList<PyBlock>(this._subBlocks);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/formatter/PyBlock", "getSubBlocks"));
        }
        return arrayList;
    }

    private List<PyBlock> buildSubBlocks() {
        ArrayList<PyBlock> blocks = new ArrayList<PyBlock>();
        for (ASTNode child = this._node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType childType = child.getElementType();
            if (child.getTextRange().getLength() == 0 || childType == TokenType.WHITE_SPACE) continue;
            blocks.add(this.buildSubBlock(child));
        }
        return Collections.unmodifiableList(blocks);
    }

    private PyBlock buildSubBlock(ASTNode child) {
        Alignment childAlignment;
        Indent childIndent;
        Wrap wrap;
        block38: {
            IElementType childType;
            IElementType parentType;
            block43: {
                block44: {
                    block42: {
                        block41: {
                            block40: {
                                block39: {
                                    block37: {
                                        parentType = this._node.getElementType();
                                        IElementType grandparentType = this._node.getTreeParent() == null ? null : this._node.getTreeParent().getElementType();
                                        childType = child.getElementType();
                                        wrap = null;
                                        childIndent = Indent.getNoneIndent();
                                        childAlignment = null;
                                        if (parentType == PyElementTypes.BINARY_EXPRESSION && !this.isInControlStatement()) {
                                            childAlignment = this.getAlignmentForChildren();
                                            PyBlock p = this.myParent;
                                            while (p != null) {
                                                ASTNode pNode = p.getNode();
                                                if (ourListElementTypes.contains(pNode.getElementType())) {
                                                    if (this.needListAlignment(child) && !PyBlock.isEmptyList(this._node.getPsi())) {
                                                        childAlignment = p.getChildAlignment();
                                                        break;
                                                    }
                                                } else if (pNode == PyElementTypes.BINARY_EXPRESSION) {
                                                    childAlignment = p.getChildAlignment();
                                                }
                                                if (PyBlock.breaksAlignment(pNode.getElementType())) break;
                                                p = p.myParent;
                                            }
                                        }
                                        if (childType == PyElementTypes.STATEMENT_LIST) {
                                            if (PyBlock.hasLineBreaksBefore(child, 1) || this.needLineBreakInStatement()) {
                                                childIndent = Indent.getNormalIndent();
                                            }
                                        } else if (childType == PyElementTypes.IMPORT_ELEMENT) {
                                            wrap = Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
                                            childIndent = Indent.getNormalIndent();
                                        }
                                        if (ourListElementTypes.contains(parentType)) {
                                            if (!(parentType == PyElementTypes.TUPLE_EXPRESSION && grandparentType != PyElementTypes.PARENTHESIZED_EXPRESSION || ourBrackets.contains(childType) || childType == PyTokenTypes.COMMA || this.isSliceOperand(child))) {
                                                wrap = Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
                                            }
                                            if (this.needListAlignment(child) && !PyBlock.isEmptyList(this._node.getPsi())) {
                                                childAlignment = this.getAlignmentForChildren();
                                            }
                                            if (childType == PyTokenTypes.END_OF_LINE_COMMENT) {
                                                childIndent = Indent.getNormalIndent();
                                            }
                                        } else if (parentType == PyElementTypes.BINARY_EXPRESSION && (PythonDialectsTokenSetProvider.INSTANCE.getExpressionTokens().contains(childType) || PyTokenTypes.OPERATIONS.contains(childType)) && this.isInControlStatement()) {
                                            PyParenthesizedExpression parens = (PyParenthesizedExpression)PsiTreeUtil.getParentOfType((PsiElement)this._node.getPsi(), PyParenthesizedExpression.class, (boolean)true, (Class[])new Class[]{PyStatementPart.class});
                                            Indent indent = childIndent = parens != null ? Indent.getNormalIndent() : Indent.getContinuationIndent();
                                        }
                                        if (parentType != PyElementTypes.LIST_LITERAL_EXPRESSION && parentType != PyElementTypes.LIST_COMP_EXPRESSION) break block37;
                                        childIndent = childType == PyTokenTypes.RBRACKET || childType == PyTokenTypes.LBRACKET ? Indent.getNoneIndent() : Indent.getNormalIndent();
                                        break block38;
                                    }
                                    if (parentType != PyElementTypes.DICT_LITERAL_EXPRESSION && parentType != PyElementTypes.SET_LITERAL_EXPRESSION && parentType != PyElementTypes.SET_COMP_EXPRESSION && parentType != PyElementTypes.DICT_COMP_EXPRESSION) break block39;
                                    childIndent = childType == PyTokenTypes.RBRACE || !PyBlock.hasLineBreaksBefore(child, 1) ? Indent.getNoneIndent() : Indent.getNormalIndent();
                                    break block38;
                                }
                                if (parentType != PyElementTypes.STRING_LITERAL_EXPRESSION) break block40;
                                if (PyTokenTypes.STRING_NODES.contains(childType)) {
                                    childAlignment = this.getAlignmentForChildren();
                                }
                                break block38;
                            }
                            if (parentType != PyElementTypes.FROM_IMPORT_STATEMENT) break block41;
                            if (this._node.findChildByType((IElementType)PyTokenTypes.LPAR) == null) break block38;
                            if (childType == PyElementTypes.IMPORT_ELEMENT) {
                                if (this.myContext.getPySettings().ALIGN_MULTILINE_IMPORTS) {
                                    childAlignment = this.getAlignmentForChildren();
                                } else {
                                    childIndent = Indent.getNormalIndent();
                                }
                            }
                            if (childType != PyTokenTypes.RPAR) break block38;
                            childIndent = Indent.getNoneIndent();
                            break block38;
                        }
                        if (parentType != PyElementTypes.KEY_VALUE_EXPRESSION) break block42;
                        PyKeyValueExpression keyValue = (PyKeyValueExpression)this._node.getPsi();
                        if (keyValue != null && child.getPsi() == keyValue.getValue()) {
                            childIndent = Indent.getNormalIndent();
                        }
                        break block38;
                    }
                    if (this.hasHangingIndent(this._node.getPsi()) || !(parentType == PyElementTypes.PARENTHESIZED_EXPRESSION && this.myContext.getSettings().ALIGN_MULTILINE_PARENTHESIZED_EXPRESSION || parentType == PyElementTypes.ARGUMENT_LIST && this.myContext.getSettings().ALIGN_MULTILINE_PARAMETERS_IN_CALLS) && (parentType != PyElementTypes.PARAMETER_LIST || !this.myContext.getSettings().ALIGN_MULTILINE_PARAMETERS) || PyBlock.isIndentNext(child) || PyBlock.hasLineBreaksBefore(this._node.getFirstChildNode(), 1) || ourListElementTypes.contains(childType)) break block43;
                    if (ourBrackets.contains(childType)) break block44;
                    childAlignment = this.getAlignmentForChildren();
                    if (parentType != PyElementTypes.CALL_EXPRESSION) {
                        childIndent = Indent.getNormalIndent();
                    }
                    break block38;
                }
                if (childType != PyTokenTypes.RPAR) break block38;
                childIndent = Indent.getNoneIndent();
                break block38;
            }
            if (parentType == PyElementTypes.GENERATOR_EXPRESSION || parentType == PyElementTypes.PARENTHESIZED_EXPRESSION) {
                childIndent = childType == PyTokenTypes.RPAR || !PyBlock.hasLineBreaksBefore(child, 1) ? Indent.getNoneIndent() : (PyBlock.isIndentNext(child) ? Indent.getContinuationIndent() : Indent.getNormalIndent());
            } else if (parentType == PyElementTypes.ARGUMENT_LIST || parentType == PyElementTypes.PARAMETER_LIST) {
                childIndent = childType == PyTokenTypes.RPAR ? Indent.getNoneIndent() : (parentType == PyElementTypes.PARAMETER_LIST || this.isInControlStatement() ? Indent.getContinuationIndent() : Indent.getNormalIndent());
            } else if (parentType == PyElementTypes.SUBSCRIPTION_EXPRESSION) {
                PyExpression indexExpression = ((PySubscriptionExpression)this._node.getPsi()).getIndexExpression();
                if (indexExpression != null && child == indexExpression.getNode()) {
                    childIndent = Indent.getNormalIndent();
                }
            } else if (parentType == PyElementTypes.REFERENCE_EXPRESSION && child != this._node.getFirstChildNode()) {
                childIndent = Indent.getNormalIndent();
                if (PyBlock.hasLineBreaksBefore(child, 1)) {
                    if (this.isInControlStatement()) {
                        childIndent = Indent.getContinuationIndent();
                    } else {
                        PyBlock b = this.myParent;
                        while (b != null) {
                            if (b.getNode().getPsi() instanceof PyParenthesizedExpression || b.getNode().getPsi() instanceof PyArgumentList || b.getNode().getPsi() instanceof PyParameterList) {
                                childAlignment = PyBlock.getAlignmentOfChild(b, 1);
                                break;
                            }
                            b = b.myParent;
                        }
                    }
                }
            }
        }
        if (PyBlock.isAfterStatementList(child) && !PyBlock.hasLineBreaksBefore(child, 2) && child.getElementType() != PyTokenTypes.END_OF_LINE_COMMENT) {
            childIndent = Indent.getNormalIndent();
        }
        for (ASTNode prev = child.getTreePrev(); prev != null && prev.getElementType() == TokenType.WHITE_SPACE; prev = prev.getTreePrev()) {
            if (!prev.getText().contains("\\") || childIndent.equals(Indent.getContinuationIndent()) || childIndent.equals(Indent.getContinuationIndent((boolean)true))) continue;
            childIndent = PyBlock.isIndentNext(child) ? Indent.getContinuationIndent() : Indent.getNormalIndent();
            break;
        }
        return new PyBlock(this, child, childAlignment, childIndent, wrap, this.myContext);
    }

    private boolean hasHangingIndent(@NotNull PsiElement elem) {
        PyElement[] items;
        if (elem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elem", "com/jetbrains/python/formatter/PyBlock", "hasHangingIndent"));
        }
        if (elem instanceof PyCallExpression) {
            PyArgumentList argumentList = ((PyCallExpression)elem).getArgumentList();
            return argumentList != null && this.hasHangingIndent((PsiElement)argumentList);
        }
        if (elem instanceof PyFunction) {
            return this.hasHangingIndent((PsiElement)((PyFunction)elem).getParameterList());
        }
        PsiElement firstChild = elem.getFirstChild();
        if (firstChild == null) {
            return false;
        }
        if (PyTokenTypes.OPEN_BRACES.contains(firstChild.getNode().getElementType()) && PyBlock.hasLineBreaksAfter(firstChild.getNode(), 1)) {
            return true;
        }
        if (elem instanceof PySequenceExpression) {
            items = ((PySequenceExpression)elem).getElements();
        } else if (elem instanceof PyParameterList) {
            items = ((PyParameterList)elem).getParameters();
        } else if (elem instanceof PyArgumentList) {
            items = ((PyArgumentList)elem).getArguments();
        } else if (elem instanceof PyParenthesizedExpression) {
            PyParenthesizedExpression parenthesizedExpr = (PyParenthesizedExpression)elem;
            items = parenthesizedExpr.getContainedExpression() instanceof PyTupleExpression ? ((PyTupleExpression)parenthesizedExpr.getContainedExpression()).getElements() : new PsiElement[]{parenthesizedExpr.getContainedExpression()};
        } else {
            return false;
        }
        return items.length == 0 || this.hasHangingIndent((PsiElement)items[0]);
    }

    private static boolean breaksAlignment(IElementType type) {
        return type != PyElementTypes.BINARY_EXPRESSION;
    }

    private static Alignment getAlignmentOfChild(PyBlock b, int childNum) {
        if (b.getSubBlocks().size() > childNum) {
            ChildAttributes attributes = b.getChildAttributes(childNum);
            return attributes.getAlignment();
        }
        return null;
    }

    private static boolean isIndentNext(ASTNode child) {
        PsiElement psi = PsiTreeUtil.getParentOfType((PsiElement)child.getPsi(), PyStatement.class);
        return psi instanceof PyIfStatement || psi instanceof PyForStatement || psi instanceof PyWithStatement || psi instanceof PyClass || psi instanceof PyFunction || psi instanceof PyTryExceptStatement || psi instanceof PyElsePart || psi instanceof PyIfPart || psi instanceof PyWhileStatement;
    }

    private static boolean isSubscriptionOperand(ASTNode child) {
        return child.getTreeParent().getElementType() == PyElementTypes.SUBSCRIPTION_EXPRESSION && child.getPsi() == ((PySubscriptionExpression)child.getTreeParent().getPsi()).getOperand();
    }

    private boolean isInControlStatement() {
        return PsiTreeUtil.getParentOfType((PsiElement)this._node.getPsi(), PyStatementPart.class, (boolean)false, (Class[])new Class[]{PyStatementList.class}) != null || PsiTreeUtil.getParentOfType((PsiElement)this._node.getPsi(), PyWithItem.class) != null;
    }

    private boolean isSliceOperand(ASTNode child) {
        if (this._node.getPsi() instanceof PySliceExpression) {
            PySliceExpression sliceExpression = (PySliceExpression)this._node.getPsi();
            PyExpression operand = sliceExpression.getOperand();
            return operand.getNode() == child;
        }
        return false;
    }

    private static boolean isEmptyList(PsiElement psi) {
        if (psi instanceof PyDictLiteralExpression) {
            return ((PyDictLiteralExpression)psi).getElements().length == 0;
        }
        if (psi instanceof PySequenceExpression) {
            return ((PySequenceExpression)psi).getElements().length == 0;
        }
        return false;
    }

    private static boolean isAfterStatementList(ASTNode child) {
        try {
            PsiElement prev = PyUtil.sure(child.getPsi().getPrevSibling());
            PyUtil.sure(prev instanceof PyStatement);
            PsiElement lastchild = PsiTreeUtil.getDeepestLast((PsiElement)prev);
            PyUtil.sure(lastchild.getParent() instanceof PyStatementList);
            return true;
        }
        catch (IncorrectOperationException e) {
            return false;
        }
    }

    private boolean needListAlignment(ASTNode child) {
        PsiElement psi;
        IElementType firstGrandchildType;
        IElementType childType = child.getElementType();
        ASTNode firstGrandchild = child.getFirstChildNode();
        IElementType iElementType = firstGrandchildType = firstGrandchild == null ? null : firstGrandchild.getElementType();
        if (PyTokenTypes.OPEN_BRACES.contains(childType)) {
            return false;
        }
        if (PyTokenTypes.OPEN_BRACES.contains(firstGrandchildType) && (psi = child.getPsi()) instanceof PySequenceExpression && ((PySequenceExpression)psi).getElements().length == 0) {
            return false;
        }
        if (PyTokenTypes.CLOSE_BRACES.contains(childType)) {
            ASTNode prevNonSpace = PyBlock.findPrevNonSpaceNode(child);
            if (prevNonSpace != null && prevNonSpace.getElementType() == PyTokenTypes.COMMA && this.myContext.getMode() == FormattingMode.ADJUST_INDENT) {
                return true;
            }
            return !this.hasHangingIndent(this._node.getPsi());
        }
        if (this._node.getElementType() == PyElementTypes.ARGUMENT_LIST) {
            if (!this.myContext.getSettings().ALIGN_MULTILINE_PARAMETERS_IN_CALLS || this.hasHangingIndent(this._node.getPsi())) {
                return false;
            }
            if (child.getElementType() == PyTokenTypes.COMMA) {
                return false;
            }
            PyArgumentList argList = (PyArgumentList)this._node.getPsi();
            if (argList != null) {
                PyExpression[] arguments = argList.getArguments();
                return arguments.length > 1 || PyBlock.hasLineBreaksBefore(child, 1) || arguments.length == 1 && PyPsiUtils.getNextComma(arguments[0].getNode()) != null;
            }
            return false;
        }
        if (this._node.getElementType() == PyElementTypes.PARAMETER_LIST) {
            return !this.hasHangingIndent(this._node.getPsi()) && this.myContext.getSettings().ALIGN_MULTILINE_PARAMETERS;
        }
        if (this._node.getElementType() == PyElementTypes.SUBSCRIPTION_EXPRESSION) {
            return false;
        }
        if (child.getElementType() == PyTokenTypes.COMMA) {
            return false;
        }
        return this.myContext.getPySettings().ALIGN_COLLECTIONS_AND_COMPREHENSIONS;
    }

    @Nullable
    private static ASTNode findPrevNonSpaceNode(ASTNode node) {
        while ((node = node.getTreePrev()) != null && (node.getElementType() == TokenType.WHITE_SPACE || PyTokenTypes.WHITESPACE.contains(node.getElementType()))) {
        }
        return node;
    }

    private static boolean hasLineBreaksBefore(@NotNull ASTNode child, int minCount) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/python/formatter/PyBlock", "hasLineBreaksBefore"));
        }
        ASTNode treePrev = child.getTreePrev();
        return treePrev != null && PyBlock.isWhitespaceWithLineBreaks(TreeUtil.findLastLeaf(treePrev), minCount) || PyBlock.isWhitespaceWithLineBreaks(child.getFirstChildNode(), minCount);
    }

    private static boolean hasLineBreaksAfter(@NotNull ASTNode child, int minCount) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/python/formatter/PyBlock", "hasLineBreaksAfter"));
        }
        ASTNode treeNext = child.getTreeNext();
        return treeNext != null && PyBlock.isWhitespaceWithLineBreaks(TreeUtil.findLastLeaf(treeNext), minCount) || PyBlock.isWhitespaceWithLineBreaks(child.getLastChildNode(), minCount);
    }

    private static boolean isWhitespaceWithLineBreaks(ASTNode node, int minCount) {
        if (node != null && node.getElementType() == TokenType.WHITE_SPACE) {
            String prevNodeText = node.getText();
            int count = 0;
            for (int i = 0; i < prevNodeText.length(); ++i) {
                if (prevNodeText.charAt(i) != '\n' || ++count != minCount) continue;
                return true;
            }
        }
        return false;
    }

    private void dumpSubBlocks() {
        System.out.println("Subblocks of " + this._node.getPsi() + ":");
        for (PyBlock block : this._subBlocks) {
            if (block instanceof PyBlock) {
                System.out.println("  " + block.getNode().getPsi().toString() + " " + block.getTextRange().getStartOffset() + ":" + block.getTextRange().getLength());
                continue;
            }
            System.out.println("  <unknown block>");
        }
    }

    @Nullable
    public Wrap getWrap() {
        return this._wrap;
    }

    @Nullable
    public Indent getIndent() {
        assert (this._indent != null);
        return this._indent;
    }

    @Nullable
    public Alignment getAlignment() {
        return this._alignment;
    }

    @Nullable
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/jetbrains/python/formatter/PyBlock", "getSpacing"));
        }
        if (child1 instanceof ASTBlock && child2 instanceof ASTBlock) {
            IElementType type3;
            PsiElement psi3;
            ASTNode node1 = ((ASTBlock)child1).getNode();
            PsiElement psi1 = node1.getPsi();
            PsiElement psi2 = ((ASTBlock)child2).getNode().getPsi();
            if (psi1 instanceof PyImportStatementBase && psi2 instanceof PyImportStatementBase && psi2.getCopyableUserData(IMPORT_GROUP_BEGIN) != null) {
                return Spacing.createSpacing((int)0, (int)0, (int)2, (boolean)true, (int)1);
            }
            if (node1.getElementType() == PyTokenTypes.COLON && psi2 instanceof PyStatementList && this.needLineBreakInStatement()) {
                return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)this.myContext.getSettings().KEEP_BLANK_LINES_IN_CODE);
            }
            if ((node1.getElementType() == PyElementTypes.FUNCTION_DECLARATION || node1.getElementType() == PyElementTypes.CLASS_DECLARATION) && this._node.getElementType() instanceof PyFileElementType && psi2 instanceof PsiComment && (psi3 = PsiTreeUtil.getNextSiblingOfType((PsiElement)psi2, PyElement.class)) != null && ((type3 = psi3.getNode().getElementType()) == PyElementTypes.CLASS_DECLARATION || type3 == PyElementTypes.FUNCTION_DECLARATION)) {
                return this.getBlankLinesForOption(this.myContext.getPySettings().BLANK_LINES_AROUND_TOP_LEVEL_CLASSES_FUNCTIONS);
            }
            if (psi2 instanceof PsiComment && !PyBlock.hasLineBreaksBefore(psi2.getNode(), 1) && this.myContext.getPySettings().SPACE_BEFORE_NUMBER_SIGN) {
                return Spacing.createSpacing((int)2, (int)0, (int)0, (boolean)false, (int)0);
            }
        }
        return this.myContext.getSpacingBuilder().getSpacing((Block)this, child1, child2);
    }

    private Spacing getBlankLinesForOption(int option) {
        int blankLines = option + 1;
        return Spacing.createSpacing((int)0, (int)0, (int)blankLines, (boolean)this.myContext.getSettings().KEEP_LINE_BREAKS, (int)this.myContext.getSettings().KEEP_BLANK_LINES_IN_DECLARATIONS);
    }

    private boolean needLineBreakInStatement() {
        Collection parts;
        PyStatement statement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)this._node.getPsi(), PyStatement.class);
        return statement != null && ((parts = PsiTreeUtil.collectElementsOfType((PsiElement)statement, (Class[])new Class[]{PyStatementPart.class})).size() == 1 && this.myContext.getPySettings().NEW_LINE_AFTER_COLON || parts.size() > 1 && this.myContext.getPySettings().NEW_LINE_AFTER_COLON_MULTI_CLAUSE);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        int statementListsBelow = 0;
        if (newChildIndex > 0) {
            if (this._node.getPsi() instanceof PyFile || this._node.getElementType() == PyTokenTypes.COLON) {
                ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
                if (childAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/formatter/PyBlock", "getChildAttributes"));
                }
                return childAttributes;
            }
            PyBlock insertAfterBlock = this._subBlocks.get(newChildIndex - 1);
            ASTNode prevNode = insertAfterBlock.getNode();
            PsiElement prevElt = prevNode.getPsi();
            if (prevElt instanceof PyStatementList) {
                if (PyBlock.dedentAfterLastStatement((PyStatementList)prevElt)) {
                    ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), this.getChildAlignment());
                    if (childAttributes == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/formatter/PyBlock", "getChildAttributes"));
                    }
                    return childAttributes;
                }
                ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
                if (childAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/formatter/PyBlock", "getChildAttributes"));
                }
                return childAttributes;
            }
            if (prevElt instanceof PyStatementPart) {
                ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
                if (childAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/formatter/PyBlock", "getChildAttributes"));
                }
                return childAttributes;
            }
            ASTNode lastChild = insertAfterBlock.getNode();
            while (lastChild != null) {
                IElementType last_type = lastChild.getElementType();
                if (last_type == PyElementTypes.STATEMENT_LIST && PyBlock.hasLineBreaksBefore(lastChild, 1)) {
                    if (PyBlock.dedentAfterLastStatement((PyStatementList)lastChild.getPsi())) break;
                    ++statementListsBelow;
                } else if (statementListsBelow > 0 && lastChild.getPsi() instanceof PsiErrorElement) {
                    ++statementListsBelow;
                }
                if (this._node.getElementType() == PyElementTypes.STATEMENT_LIST && lastChild.getPsi() instanceof PsiErrorElement) {
                    ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
                    if (childAttributes == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/formatter/PyBlock", "getChildAttributes"));
                    }
                    return childAttributes;
                }
                lastChild = PyBlock.getLastNonSpaceChild(lastChild, true);
            }
        }
        if (statementListsBelow > 0) {
            int indent = this.myContext.getSettings().getIndentOptions().INDENT_SIZE;
            ChildAttributes childAttributes = new ChildAttributes(Indent.getSpaceIndent((int)(indent * statementListsBelow)), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/formatter/PyBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        Indent childIndent = this.getChildIndent(newChildIndex);
        Alignment childAlignment = this.getChildAlignment();
        ChildAttributes childAttributes = new ChildAttributes(childIndent, childAlignment);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/formatter/PyBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    private static boolean dedentAfterLastStatement(PyStatementList statementList) {
        PyStatement[] statements = statementList.getStatements();
        if (statements.length == 0) {
            return false;
        }
        PyStatement last = statements[statements.length - 1];
        return last instanceof PyReturnStatement || last instanceof PyRaiseStatement || last instanceof PyPassStatement;
    }

    @Nullable
    private Alignment getChildAlignment() {
        if (ourListElementTypes.contains(this._node.getElementType())) {
            if (this.isInControlStatement()) {
                return null;
            }
            if (this._node.getPsi() instanceof PyParameterList && !this.myContext.getSettings().ALIGN_MULTILINE_PARAMETERS) {
                return null;
            }
            if (this._node.getPsi() instanceof PyDictLiteralExpression) {
                PyKeyValueExpression[] elements = ((PyDictLiteralExpression)this._node.getPsi()).getElements();
                if (elements.length == 0) {
                    return null;
                }
                PyKeyValueExpression last = elements[elements.length - 1];
                if (last.getValue() == null) {
                    return null;
                }
            }
            return this.getAlignmentForChildren();
        }
        return null;
    }

    private Indent getChildIndent(int newChildIndex) {
        PyKeyValueExpression keyValue;
        ASTNode lastLastChild;
        ASTNode afterNode = this.getAfterNode(newChildIndex);
        ASTNode lastChild = PyBlock.getLastNonSpaceChild(this._node, false);
        if (lastChild != null && lastChild.getElementType() == PyElementTypes.STATEMENT_LIST && this._subBlocks.size() >= newChildIndex) {
            if (afterNode == null) {
                return Indent.getNoneIndent();
            }
            if (afterNode.getElementType() == PyElementTypes.STATEMENT_LIST || afterNode.getElementType() == PyTokenTypes.COLON) {
                return Indent.getNormalIndent();
            }
            ASTNode lastFirstChild = lastChild.getFirstChildNode();
            if (lastFirstChild != null && lastFirstChild == lastChild.getLastChildNode() && lastFirstChild.getPsi() instanceof PsiErrorElement) {
                return Indent.getNormalIndent();
            }
        } else if (lastChild != null && PyElementTypes.LIST_LIKE_EXPRESSIONS.contains(lastChild.getElementType()) && (lastLastChild = lastChild.getLastChildNode()) != null && lastLastChild.getPsi() instanceof PsiErrorElement) {
            PsiDocumentManager docMgr;
            Document doc;
            PsiElement exprItem;
            PsiElement expr = lastChild.getPsi();
            boolean found = false;
            for (exprItem = expr.getFirstChild(); exprItem != null; exprItem = exprItem.getNextSibling()) {
                if (exprItem instanceof PyElement) {
                    found = true;
                    break;
                }
                if (!(exprItem instanceof PsiComment)) continue;
                found = true;
                break;
            }
            if (found && (doc = (docMgr = PsiDocumentManager.getInstance((Project)exprItem.getProject())).getDocument(exprItem.getContainingFile())) != null) {
                int line_num = doc.getLineNumber(exprItem.getTextOffset());
                int item_col = exprItem.getTextOffset() - doc.getLineStartOffset(line_num);
                PsiElement here_elt = this.getNode().getPsi();
                line_num = doc.getLineNumber(here_elt.getTextOffset());
                int node_col = here_elt.getTextOffset() - doc.getLineStartOffset(line_num);
                int padding = item_col - node_col;
                if (padding > 0) {
                    return Indent.getSpaceIndent((int)padding);
                }
            }
            return Indent.getContinuationIndent();
        }
        if (afterNode != null && afterNode.getElementType() == PyElementTypes.KEY_VALUE_EXPRESSION && (keyValue = (PyKeyValueExpression)afterNode.getPsi()) != null && keyValue.getValue() == null) {
            return Indent.getContinuationIndent();
        }
        if (this._node.getElementType().equals(PyElementTypes.PARAMETER_LIST)) {
            return Indent.getContinuationIndent();
        }
        if (ourListElementTypes.contains(this._node.getElementType()) || this._node.getPsi() instanceof PyStatementPart) {
            return Indent.getNormalIndent();
        }
        if (afterNode != null) {
            for (ASTNode wsAfter = afterNode.getTreeNext(); wsAfter != null && wsAfter.getElementType() == TokenType.WHITE_SPACE; wsAfter = wsAfter.getTreeNext()) {
                if (wsAfter.getText().indexOf(92) < 0) continue;
                return Indent.getNormalIndent();
            }
        }
        return Indent.getNoneIndent();
    }

    @Nullable
    private ASTNode getAfterNode(int newChildIndex) {
        int prevIndex;
        if (newChildIndex == 0) {
            return null;
        }
        for (prevIndex = newChildIndex - 1; prevIndex > 0 && this._subBlocks.get(prevIndex).getNode().getElementType() == PyTokenTypes.END_OF_LINE_COMMENT; --prevIndex) {
        }
        PyBlock insertAfterBlock = this._subBlocks.get(prevIndex);
        return insertAfterBlock.getNode();
    }

    private static ASTNode getLastNonSpaceChild(ASTNode node, boolean acceptError) {
        ASTNode lastChild;
        for (lastChild = node.getLastChildNode(); lastChild != null && (lastChild.getElementType() == TokenType.WHITE_SPACE || !acceptError && lastChild.getPsi() instanceof PsiErrorElement); lastChild = lastChild.getTreePrev()) {
        }
        return lastChild;
    }

    public boolean isIncomplete() {
        ASTNode lastChild;
        if (!PsiTreeUtil.hasErrorElements((PsiElement)this._node.getPsi())) {
            PsiElement element = this._node.getPsi().getNextSibling();
            while (element instanceof PsiWhiteSpace) {
                element = element.getNextSibling();
            }
            if (element != null) {
                return false;
            }
        }
        if ((lastChild = PyBlock.getLastNonSpaceChild(this._node, false)) != null) {
            PyBinaryExpression binaryExpression;
            ASTNode statementListPrev;
            if (lastChild.getElementType() == PyElementTypes.STATEMENT_LIST && (statementListPrev = lastChild.getTreePrev()) != null && statementListPrev.getText().indexOf(10) >= 0) {
                return true;
            }
            if (lastChild.getElementType() == PyElementTypes.BINARY_EXPRESSION && (binaryExpression = (PyBinaryExpression)lastChild.getPsi()).getRightExpression() == null) {
                return true;
            }
            if (PyBlock.isIncompleteCall(lastChild)) {
                return true;
            }
        }
        if (this._node.getPsi() instanceof PyArgumentList) {
            PyArgumentList argumentList = (PyArgumentList)this._node.getPsi();
            return argumentList.getClosingParen() == null;
        }
        return PyBlock.isIncompleteCall(this._node);
    }

    private static boolean isIncompleteCall(ASTNode node) {
        PyCallExpression callExpression;
        PyArgumentList argumentList;
        return node.getElementType() == PyElementTypes.CALL_EXPRESSION && ((argumentList = (callExpression = (PyCallExpression)node.getPsi()).getArgumentList()) == null || argumentList.getClosingParen() == null);
    }

    public boolean isLeaf() {
        return this._node.getFirstChildNode() == null;
    }
}

