/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.findUsages;

import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.findUsages.PyWordsScanner;
import com.jetbrains.python.magicLiteral.PyMagicLiteralExtensionPoint;
import com.jetbrains.python.magicLiteral.PyMagicLiteralTools;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.StringLiteralExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonFindUsagesProvider
implements FindUsagesProvider {
    public boolean canFindUsagesFor(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/python/findUsages/PythonFindUsagesProvider", "canFindUsagesFor"));
        }
        if (PyMagicLiteralTools.isMagicLiteral(psiElement)) {
            return true;
        }
        return psiElement instanceof PsiNamedElement || psiElement instanceof PyReferenceExpression;
    }

    public String getHelpId(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/python/findUsages/PythonFindUsagesProvider", "getHelpId"));
        }
        if (psiElement instanceof PyClass) {
            return "reference.dialogs.findUsages.class";
        }
        if (psiElement instanceof PyFunction) {
            return "reference.dialogs.findUsages.method";
        }
        if (psiElement instanceof PyReferenceExpression || psiElement instanceof PyTargetExpression || psiElement instanceof PyParameter) {
            return "reference.dialogs.findUsages.variable";
        }
        return null;
    }

    @NotNull
    public String getType(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/findUsages/PythonFindUsagesProvider", "getType"));
        }
        String literalString = PythonFindUsagesProvider.tryFindMagicLiteralString(element, false);
        if (literalString != null) {
            String string = literalString;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/findUsages/PythonFindUsagesProvider", "getType"));
            }
            return string;
        }
        if (element instanceof PyNamedParameter) {
            if ("parameter" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/findUsages/PythonFindUsagesProvider", "getType"));
            }
            return "parameter";
        }
        if (element instanceof PyFunction) {
            if (((PyFunction)element).getContainingClass() != null) {
                if ("method" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/findUsages/PythonFindUsagesProvider", "getType"));
                }
                return "method";
            }
            if ("function" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/findUsages/PythonFindUsagesProvider", "getType"));
            }
            return "function";
        }
        if (element instanceof PyClass) {
            if ("class" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/findUsages/PythonFindUsagesProvider", "getType"));
            }
            return "class";
        }
        if (element instanceof PyReferenceExpression) {
            if ("variable" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/findUsages/PythonFindUsagesProvider", "getType"));
            }
            return "variable";
        }
        if (element instanceof PyTargetExpression) {
            PyImportElement importElement = (PyImportElement)PsiTreeUtil.getParentOfType((PsiElement)element, PyImportElement.class);
            if (importElement != null && importElement.getAsNameElement() == element) {
                if ("imported module alias" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/findUsages/PythonFindUsagesProvider", "getType"));
                }
                return "imported module alias";
            }
            if ("variable" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/findUsages/PythonFindUsagesProvider", "getType"));
            }
            return "variable";
        }
        if (element instanceof PyKeywordArgument) {
            if ("keyword argument" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/findUsages/PythonFindUsagesProvider", "getType"));
            }
            return "keyword argument";
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/findUsages/PythonFindUsagesProvider", "getType"));
        }
        return "";
    }

    @NotNull
    public String getDescriptiveName(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/findUsages/PythonFindUsagesProvider", "getDescriptiveName"));
        }
        String literalString = PythonFindUsagesProvider.tryFindMagicLiteralString(element, true);
        if (literalString != null) {
            String string = literalString;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/findUsages/PythonFindUsagesProvider", "getDescriptiveName"));
            }
            return string;
        }
        if (element instanceof PsiNamedElement) {
            String name = ((PsiNamedElement)element).getName();
            String string = name == null ? "<unnamed>" : name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/findUsages/PythonFindUsagesProvider", "getDescriptiveName"));
            }
            return string;
        }
        if (element instanceof PyReferenceExpression) {
            String referencedName = ((PyReferenceExpression)element).getReferencedName();
            if (referencedName == null) {
                if ("<unnamed>" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/findUsages/PythonFindUsagesProvider", "getDescriptiveName"));
                }
                return "<unnamed>";
            }
            String string = referencedName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/findUsages/PythonFindUsagesProvider", "getDescriptiveName"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/findUsages/PythonFindUsagesProvider", "getDescriptiveName"));
        }
        return "";
    }

    @NotNull
    public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/findUsages/PythonFindUsagesProvider", "getNodeText"));
        }
        if (element instanceof PyNamedParameter) {
            StringBuilder result = new StringBuilder(((PyNamedParameter)element).getName());
            PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
            if (function != null) {
                result.append(" of ");
                PythonFindUsagesProvider.appendFunctionDescription(result, function);
            }
            String string = result.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/findUsages/PythonFindUsagesProvider", "getNodeText"));
            }
            return string;
        }
        if (element instanceof PyFunction) {
            StringBuilder result = new StringBuilder();
            PythonFindUsagesProvider.appendFunctionDescription(result, (PyFunction)element);
            String string = result.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/findUsages/PythonFindUsagesProvider", "getNodeText"));
            }
            return string;
        }
        String string = this.getDescriptiveName(element);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/findUsages/PythonFindUsagesProvider", "getNodeText"));
        }
        return string;
    }

    private static void appendFunctionDescription(StringBuilder result, PyFunction function) {
        result.append(function.getName()).append("()");
        PyClass containingClass = function.getContainingClass();
        if (containingClass != null) {
            result.append(" of class ").append(containingClass.getName());
        }
    }

    public WordsScanner getWordsScanner() {
        return new PyWordsScanner();
    }

    @Nullable
    private static String tryFindMagicLiteralString(@NotNull PsiElement element, boolean obtainValue) {
        PyMagicLiteralExtensionPoint point;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/findUsages/PythonFindUsagesProvider", "tryFindMagicLiteralString"));
        }
        if (element instanceof PyStringLiteralExpression && (point = PyMagicLiteralTools.getPoint((PyStringLiteralExpression)element)) != null) {
            if (obtainValue) {
                return ((StringLiteralExpression)element).getStringValue();
            }
            return point.getLiteralType();
        }
        return null;
    }
}

