/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.findUsages;

import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.CommonFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyImportedModule;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PyModuleFindUsagesHandler
extends FindUsagesHandler {
    private final PsiFileSystemItem myElement;

    protected PyModuleFindUsagesHandler(@NotNull PsiFileSystemItem file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/findUsages/PyModuleFindUsagesHandler", "<init>"));
        }
        super((PsiElement)file);
        PsiElement e = PyUtil.turnInitIntoDir((PsiElement)file);
        this.myElement = e instanceof PsiFileSystemItem ? (PsiFileSystemItem)e : file;
    }

    @Override
    @NotNull
    public PsiElement[] getPrimaryElements() {
        PsiElement[] psiElementArray = new PsiElement[]{this.myElement};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/findUsages/PyModuleFindUsagesHandler", "getPrimaryElements"));
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public AbstractFindUsagesDialog getFindUsagesDialog(boolean isSingleFile, boolean toShowInNewTab, boolean mustOpenInNewTab) {
        CommonFindUsagesDialog commonFindUsagesDialog = new CommonFindUsagesDialog((PsiElement)this.myElement, this.getProject(), this.getFindUsagesOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, this){

            @Override
            public void configureLabelComponent(@NotNull SimpleColoredComponent coloredComponent) {
                if (coloredComponent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coloredComponent", "com/jetbrains/python/findUsages/PyModuleFindUsagesHandler$1", "configureLabelComponent"));
                }
                coloredComponent.append(PyModuleFindUsagesHandler.this.myElement instanceof PsiDirectory ? "Package " : "Module ");
                coloredComponent.append(PyModuleFindUsagesHandler.this.myElement.getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
        };
        if (commonFindUsagesDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/findUsages/PyModuleFindUsagesHandler", "getFindUsagesDialog"));
        }
        return commonFindUsagesDialog;
    }

    @Override
    @NotNull
    public Collection<PsiReference> findReferencesToHighlight(@NotNull PsiElement target, @NotNull SearchScope searchScope) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/python/findUsages/PyModuleFindUsagesHandler", "findReferencesToHighlight"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/jetbrains/python/findUsages/PyModuleFindUsagesHandler", "findReferencesToHighlight"));
        }
        if (target instanceof PyImportedModule) {
            target = ((PyImportedModule)target).resolve();
        }
        if (target instanceof PyFile && "__init__.py".equals(((PyFile)target).getName())) {
            ArrayList<PsiReference> result = new ArrayList<PsiReference>();
            result.addAll(super.findReferencesToHighlight(target, searchScope));
            PsiElement targetDir = PyUtil.turnInitIntoDir(target);
            if (targetDir != null) {
                result.addAll(ReferencesSearch.search((PsiElement)targetDir, (SearchScope)searchScope, (boolean)false).findAll());
            }
            ArrayList<PsiReference> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/findUsages/PyModuleFindUsagesHandler", "findReferencesToHighlight"));
            }
            return arrayList;
        }
        Collection<PsiReference> collection = super.findReferencesToHighlight(target, searchScope);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/findUsages/PyModuleFindUsagesHandler", "findReferencesToHighlight"));
        }
        return collection;
    }
}

