/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.findUsages;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.jetbrains.python.findUsages.PyClassFindUsagesHandler;
import com.jetbrains.python.findUsages.PyFunctionFindUsagesHandler;
import com.jetbrains.python.findUsages.PyModuleFindUsagesHandler;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    @Override
    public boolean canFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/findUsages/PyFindUsagesHandlerFactory", "canFindUsages"));
        }
        return element instanceof PyClass || element instanceof PyFile && PyUtil.isPackage((PyFile)element) || element instanceof PyImportedModule || element instanceof PyFunction;
    }

    @Override
    @Nullable
    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        PsiElement resolved;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/findUsages/PyFindUsagesHandlerFactory", "createFindUsagesHandler"));
        }
        if (element instanceof PyImportedModule && (resolved = ((PyImportedModule)element).resolve()) != null) {
            element = resolved;
        }
        if (element instanceof PsiFileSystemItem) {
            return new PyModuleFindUsagesHandler((PsiFileSystemItem)element);
        }
        if (element instanceof PyFunction) {
            PsiElement next;
            Collection superMethods;
            if (!forHighlightUsages && (superMethods = PySuperMethodsSearch.search((PyFunction)element, true).findAll()).size() > 0 && (next = (PsiElement)superMethods.iterator().next()) instanceof PyFunction && !PyFindUsagesHandlerFactory.isInObject((PyFunction)next)) {
                int rc = Messages.showYesNoCancelDialog((Project)element.getProject(), (String)("Method " + ((PyFunction)element).getName() + " overrides method of class " + ((PyFunction)next).getContainingClass().getName() + ".\nDo you want to find usages of the base method?"), (String)"Find Usages", (Icon)Messages.getQuestionIcon());
                if (rc == 0) {
                    ArrayList<PsiElement> allMethods = new ArrayList<PsiElement>();
                    allMethods.add(element);
                    allMethods.addAll(superMethods);
                    return new PyFunctionFindUsagesHandler(element, allMethods);
                }
                if (rc == 1) {
                    return new PyFunctionFindUsagesHandler(element);
                }
                return FindUsagesHandler.NULL_HANDLER;
            }
            return new PyFunctionFindUsagesHandler(element);
        }
        if (element instanceof PyClass) {
            return new PyClassFindUsagesHandler((PyClass)element);
        }
        return null;
    }

    private static boolean isInObject(PyFunction fun) {
        PyClass containingClass = fun.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        return PyUtil.isObjectClass(containingClass);
    }
}

